<?php
/**
 * ConnectApi
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\ConnectApi;

class GetEventLogOptions
{
    /**
      * $additional_info When true, the connectDebugLog information is included in the response.
      * @var string
      */
    protected $additional_info;

    /**
     * Gets additional_info
     * @return string
     */
    public function getAdditionalInfo()
    {
        return $this->additional_info;
    }
  
    /**
     * Sets additional_info
     * @param string $additional_info When true, the connectDebugLog information is included in the response.
     * @return $this
     */
    public function setAdditionalInfo($additional_info)
    {
        $this->additional_info = $additional_info;
        return $this;
    }
}
class ListEventFailureLogsOptions
{
    /**
      * $from_date 
      * @var string
      */
    protected $from_date;

    /**
     * Gets from_date
     * @return string
     */
    public function getFromDate()
    {
        return $this->from_date;
    }
  
    /**
     * Sets from_date
     * @param string $from_date 
     * @return $this
     */
    public function setFromDate($from_date)
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $to_date 
      * @var string
      */
    protected $to_date;

    /**
     * Gets to_date
     * @return string
     */
    public function getToDate()
    {
        return $this->to_date;
    }
  
    /**
     * Sets to_date
     * @param string $to_date 
     * @return $this
     */
    public function setToDate($to_date)
    {
        $this->to_date = $to_date;
        return $this;
    }
}
class ListEventLogsOptions
{
    /**
      * $from_date 
      * @var string
      */
    protected $from_date;

    /**
     * Gets from_date
     * @return string
     */
    public function getFromDate()
    {
        return $this->from_date;
    }
  
    /**
     * Sets from_date
     * @param string $from_date 
     * @return $this
     */
    public function setFromDate($from_date)
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $to_date 
      * @var string
      */
    protected $to_date;

    /**
     * Gets to_date
     * @return string
     */
    public function getToDate()
    {
        return $this->to_date;
    }
  
    /**
     * Sets to_date
     * @param string $to_date 
     * @return $this
     */
    public function setToDate($to_date)
    {
        $this->to_date = $to_date;
        return $this;
    }
}
class ListUsersOptions
{
    /**
      * $count 
      * @var string
      */
    protected $count;

    /**
     * Gets count
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }
  
    /**
     * Sets count
     * @param string $count 
     * @return $this
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $email_substring 
      * @var string
      */
    protected $email_substring;

    /**
     * Gets email_substring
     * @return string
     */
    public function getEmailSubstring()
    {
        return $this->email_substring;
    }
  
    /**
     * Sets email_substring
     * @param string $email_substring 
     * @return $this
     */
    public function setEmailSubstring($email_substring)
    {
        $this->email_substring = $email_substring;
        return $this;
    }
    /**
      * $list_included_users 
      * @var string
      */
    protected $list_included_users;

    /**
     * Gets list_included_users
     * @return string
     */
    public function getListIncludedUsers()
    {
        return $this->list_included_users;
    }
  
    /**
     * Sets list_included_users
     * @param string $list_included_users 
     * @return $this
     */
    public function setListIncludedUsers($list_included_users)
    {
        $this->list_included_users = $list_included_users;
        return $this;
    }
    /**
      * $start_position 
      * @var string
      */
    protected $start_position;

    /**
     * Gets start_position
     * @return string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }
  
    /**
     * Sets start_position
     * @param string $start_position 
     * @return $this
     */
    public function setStartPosition($start_position)
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $status 
      * @var string
      */
    protected $status;

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
  
    /**
     * Sets status
     * @param string $status 
     * @return $this
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }
    /**
      * $user_name_substring 
      * @var string
      */
    protected $user_name_substring;

    /**
     * Gets user_name_substring
     * @return string
     */
    public function getUserNameSubstring()
    {
        return $this->user_name_substring;
    }
  
    /**
     * Sets user_name_substring
     * @param string $user_name_substring 
     * @return $this
     */
    public function setUserNameSubstring($user_name_substring)
    {
        $this->user_name_substring = $user_name_substring;
        return $this;
    }
}


namespace DocuSign\eSign\Api;

use \DocuSign\eSign\ApiClient;
use \DocuSign\eSign\ApiException;
use \DocuSign\eSign\Configuration;
use \DocuSign\eSign\ObjectSerializer;

/**
 * ConnectApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ConnectApi
{
    /**
     * API Client
     *
     * @var \DocuSign\eSign\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \DocuSign\eSign\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\DocuSign\eSign\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \DocuSign\eSign\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \DocuSign\eSign\ApiClient $apiClient set the API client
     *
     * @return ConnectApi
     */
    public function setApiClient(\DocuSign\eSign\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createConfiguration
     *
     * Creates a connect configuration for the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectCustomConfiguration $connect_custom_configuration  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectCustomConfiguration
     */
    public function createConfiguration($account_id, $connect_custom_configuration = null)
    {
        list($response) = $this->createConfigurationWithHttpInfo($account_id, $connect_custom_configuration);
        return $response;
    }

    /**
     * Operation createConfigurationWithHttpInfo
     *
     * Creates a connect configuration for the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectCustomConfiguration $connect_custom_configuration  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectCustomConfiguration, HTTP status code, HTTP response headers (array of strings)
     */
    public function createConfigurationWithHttpInfo($account_id, $connect_custom_configuration = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($connect_custom_configuration)) {
            $_tempBody = $connect_custom_configuration;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectCustomConfiguration',
                '/v2/accounts/{accountId}/connect'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectCustomConfiguration', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectCustomConfiguration', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteConfiguration
     *
     * Deletes the specified connect configuration.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $connect_id The ID of the custom Connect configuration being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteConfiguration($account_id, $connect_id)
    {
        list($response) = $this->deleteConfigurationWithHttpInfo($account_id, $connect_id);
        return $response;
    }

    /**
     * Operation deleteConfigurationWithHttpInfo
     *
     * Deletes the specified connect configuration.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $connect_id The ID of the custom Connect configuration being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteConfigurationWithHttpInfo($account_id, $connect_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteConfiguration');
        }
        // verify the required parameter 'connect_id' is set
        if ($connect_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $connect_id when calling deleteConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/{connectId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($connect_id !== null) {
            $resourcePath = str_replace(
                "{" . "connectId" . "}",
                $this->apiClient->getSerializer()->toPathValue($connect_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/connect/{connectId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEventFailureLog
     *
     * Deletes a Connect failure log entry.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $failure_id The ID of the failed connect log entry.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteEventFailureLog($account_id, $failure_id)
    {
        list($response) = $this->deleteEventFailureLogWithHttpInfo($account_id, $failure_id);
        return $response;
    }

    /**
     * Operation deleteEventFailureLogWithHttpInfo
     *
     * Deletes a Connect failure log entry.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $failure_id The ID of the failed connect log entry.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEventFailureLogWithHttpInfo($account_id, $failure_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEventFailureLog');
        }
        // verify the required parameter 'failure_id' is set
        if ($failure_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $failure_id when calling deleteEventFailureLog');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/failures/{failureId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($failure_id !== null) {
            $resourcePath = str_replace(
                "{" . "failureId" . "}",
                $this->apiClient->getSerializer()->toPathValue($failure_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/connect/failures/{failureId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEventLog
     *
     * Deletes a specified Connect log entry.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $log_id The ID of the connect log entry
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteEventLog($account_id, $log_id)
    {
        list($response) = $this->deleteEventLogWithHttpInfo($account_id, $log_id);
        return $response;
    }

    /**
     * Operation deleteEventLogWithHttpInfo
     *
     * Deletes a specified Connect log entry.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $log_id The ID of the connect log entry
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEventLogWithHttpInfo($account_id, $log_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEventLog');
        }
        // verify the required parameter 'log_id' is set
        if ($log_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $log_id when calling deleteEventLog');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/logs/{logId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($log_id !== null) {
            $resourcePath = str_replace(
                "{" . "logId" . "}",
                $this->apiClient->getSerializer()->toPathValue($log_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/connect/logs/{logId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEventLogs
     *
     * Gets a list of Connect log entries.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteEventLogs($account_id)
    {
        list($response) = $this->deleteEventLogsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation deleteEventLogsWithHttpInfo
     *
     * Gets a list of Connect log entries.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEventLogsWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEventLogs');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/logs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/connect/logs'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteMobileNotifiers
     *
     * Reserved
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\MobileNotifierConfigurationInformation $mobile_notifier_configuration_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\MobileNotifierConfigurationInformation
     */
    public function deleteMobileNotifiers($account_id, $mobile_notifier_configuration_information = null)
    {
        list($response) = $this->deleteMobileNotifiersWithHttpInfo($account_id, $mobile_notifier_configuration_information);
        return $response;
    }

    /**
     * Operation deleteMobileNotifiersWithHttpInfo
     *
     * Reserved
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\MobileNotifierConfigurationInformation $mobile_notifier_configuration_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\MobileNotifierConfigurationInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteMobileNotifiersWithHttpInfo($account_id, $mobile_notifier_configuration_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteMobileNotifiers');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/mobile_notifiers";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($mobile_notifier_configuration_information)) {
            $_tempBody = $mobile_notifier_configuration_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation',
                '/v2/accounts/{accountId}/connect/mobile_notifiers'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConfiguration
     *
     * Get a Connect Configuration Information
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $connect_id The ID of the custom Connect configuration being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectConfigResults
     */
    public function getConfiguration($account_id, $connect_id)
    {
        list($response) = $this->getConfigurationWithHttpInfo($account_id, $connect_id);
        return $response;
    }

    /**
     * Operation getConfigurationWithHttpInfo
     *
     * Get a Connect Configuration Information
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $connect_id The ID of the custom Connect configuration being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectConfigResults, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConfigurationWithHttpInfo($account_id, $connect_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConfiguration');
        }
        // verify the required parameter 'connect_id' is set
        if ($connect_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $connect_id when calling getConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/{connectId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($connect_id !== null) {
            $resourcePath = str_replace(
                "{" . "connectId" . "}",
                $this->apiClient->getSerializer()->toPathValue($connect_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectConfigResults',
                '/v2/accounts/{accountId}/connect/{connectId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectConfigResults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectConfigResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEventLog
     *
     * Get the specified Connect log entry.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $log_id The ID of the connect log entry
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectLog
     */
    public function getEventLog($account_id, $log_id, ConnectApi\GetEventLogOptions $options = null)
    {
        list($response) = $this->getEventLogWithHttpInfo($account_id, $log_id, $options);
        return $response;
    }

    /**
     * Operation getEventLogWithHttpInfo
     *
     * Get the specified Connect log entry.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $log_id The ID of the connect log entry
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectLog, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEventLogWithHttpInfo($account_id, $log_id, ConnectApi\GetEventLogOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEventLog');
        }
        // verify the required parameter 'log_id' is set
        if ($log_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $log_id when calling getEventLog');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/logs/{logId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getAdditionalInfo() !== null) {
            $queryParams['additional_info'] = $this->apiClient->getSerializer()->toQueryValue($options->getAdditionalInfo());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($log_id !== null) {
            $resourcePath = str_replace(
                "{" . "logId" . "}",
                $this->apiClient->getSerializer()->toPathValue($log_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectLog',
                '/v2/accounts/{accountId}/connect/logs/{logId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectLog', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectLog', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listConfigurations
     *
     * Get Connect Configuration Information
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectConfigResults
     */
    public function listConfigurations($account_id)
    {
        list($response) = $this->listConfigurationsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listConfigurationsWithHttpInfo
     *
     * Get Connect Configuration Information
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectConfigResults, HTTP status code, HTTP response headers (array of strings)
     */
    public function listConfigurationsWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listConfigurations');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectConfigResults',
                '/v2/accounts/{accountId}/connect'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectConfigResults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectConfigResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listEventFailureLogs
     *
     * Gets the Connect failure log information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectLogs
     */
    public function listEventFailureLogs($account_id, ConnectApi\ListEventFailureLogsOptions $options = null)
    {
        list($response) = $this->listEventFailureLogsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listEventFailureLogsWithHttpInfo
     *
     * Gets the Connect failure log information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectLogs, HTTP status code, HTTP response headers (array of strings)
     */
    public function listEventFailureLogsWithHttpInfo($account_id, ConnectApi\ListEventFailureLogsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listEventFailureLogs');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/failures";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getFromDate() !== null) {
            $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
        }
        // query params
        if ($options->getToDate() !== null) {
            $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectLogs',
                '/v2/accounts/{accountId}/connect/failures'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectLogs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectLogs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listEventLogs
     *
     * Gets the Connect log.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectLogs
     */
    public function listEventLogs($account_id, ConnectApi\ListEventLogsOptions $options = null)
    {
        list($response) = $this->listEventLogsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listEventLogsWithHttpInfo
     *
     * Gets the Connect log.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectLogs, HTTP status code, HTTP response headers (array of strings)
     */
    public function listEventLogsWithHttpInfo($account_id, ConnectApi\ListEventLogsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listEventLogs');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/logs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getFromDate() !== null) {
            $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
        }
        // query params
        if ($options->getToDate() !== null) {
            $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectLogs',
                '/v2/accounts/{accountId}/connect/logs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectLogs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectLogs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listMobileNotifiers
     *
     * Reserved
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\MobileNotifierConfigurationInformation
     */
    public function listMobileNotifiers($account_id)
    {
        list($response) = $this->listMobileNotifiersWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listMobileNotifiersWithHttpInfo
     *
     * Reserved
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\MobileNotifierConfigurationInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listMobileNotifiersWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listMobileNotifiers');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/mobile_notifiers";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation',
                '/v2/accounts/{accountId}/connect/mobile_notifiers'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listUsers
     *
     * Returns users from the configured Connect service.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $connect_id The ID of the custom Connect configuration being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\IntegratedUserInfoList
     */
    public function listUsers($account_id, $connect_id, ConnectApi\ListUsersOptions $options = null)
    {
        list($response) = $this->listUsersWithHttpInfo($account_id, $connect_id, $options);
        return $response;
    }

    /**
     * Operation listUsersWithHttpInfo
     *
     * Returns users from the configured Connect service.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $connect_id The ID of the custom Connect configuration being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\IntegratedUserInfoList, HTTP status code, HTTP response headers (array of strings)
     */
    public function listUsersWithHttpInfo($account_id, $connect_id, ConnectApi\ListUsersOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listUsers');
        }
        // verify the required parameter 'connect_id' is set
        if ($connect_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $connect_id when calling listUsers');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/{connectId}/users";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getCount() !== null) {
            $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
        }
        // query params
        if ($options->getEmailSubstring() !== null) {
            $queryParams['email_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmailSubstring());
        }
        // query params
        if ($options->getListIncludedUsers() !== null) {
            $queryParams['list_included_users'] = $this->apiClient->getSerializer()->toQueryValue($options->getListIncludedUsers());
        }
        // query params
        if ($options->getStartPosition() !== null) {
            $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
        }
        // query params
        if ($options->getStatus() !== null) {
            $queryParams['status'] = $this->apiClient->getSerializer()->toQueryValue($options->getStatus());
        }
        // query params
        if ($options->getUserNameSubstring() !== null) {
            $queryParams['user_name_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserNameSubstring());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($connect_id !== null) {
            $resourcePath = str_replace(
                "{" . "connectId" . "}",
                $this->apiClient->getSerializer()->toPathValue($connect_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\IntegratedUserInfoList',
                '/v2/accounts/{accountId}/connect/{connectId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\IntegratedUserInfoList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\IntegratedUserInfoList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation retryEventForEnvelope
     *
     * Republishes Connect information for the specified envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectFailureResults
     */
    public function retryEventForEnvelope($account_id, $envelope_id)
    {
        list($response) = $this->retryEventForEnvelopeWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation retryEventForEnvelopeWithHttpInfo
     *
     * Republishes Connect information for the specified envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectFailureResults, HTTP status code, HTTP response headers (array of strings)
     */
    public function retryEventForEnvelopeWithHttpInfo($account_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling retryEventForEnvelope');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling retryEventForEnvelope');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/envelopes/{envelopeId}/retry_queue";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectFailureResults',
                '/v2/accounts/{accountId}/connect/envelopes/{envelopeId}/retry_queue'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectFailureResults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectFailureResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation retryEventForEnvelopes
     *
     * Republishes Connect information for multiple envelopes.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectFailureFilter $connect_failure_filter  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectFailureResults
     */
    public function retryEventForEnvelopes($account_id, $connect_failure_filter = null)
    {
        list($response) = $this->retryEventForEnvelopesWithHttpInfo($account_id, $connect_failure_filter);
        return $response;
    }

    /**
     * Operation retryEventForEnvelopesWithHttpInfo
     *
     * Republishes Connect information for multiple envelopes.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectFailureFilter $connect_failure_filter  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectFailureResults, HTTP status code, HTTP response headers (array of strings)
     */
    public function retryEventForEnvelopesWithHttpInfo($account_id, $connect_failure_filter = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling retryEventForEnvelopes');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/envelopes/retry_queue";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($connect_failure_filter)) {
            $_tempBody = $connect_failure_filter;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectFailureResults',
                '/v2/accounts/{accountId}/connect/envelopes/retry_queue'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectFailureResults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectFailureResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateConfiguration
     *
     * Updates a specified Connect configuration.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectCustomConfiguration $connect_custom_configuration  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectCustomConfiguration
     */
    public function updateConfiguration($account_id, $connect_custom_configuration = null)
    {
        list($response) = $this->updateConfigurationWithHttpInfo($account_id, $connect_custom_configuration);
        return $response;
    }

    /**
     * Operation updateConfigurationWithHttpInfo
     *
     * Updates a specified Connect configuration.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectCustomConfiguration $connect_custom_configuration  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectCustomConfiguration, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateConfigurationWithHttpInfo($account_id, $connect_custom_configuration = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($connect_custom_configuration)) {
            $_tempBody = $connect_custom_configuration;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectCustomConfiguration',
                '/v2/accounts/{accountId}/connect'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectCustomConfiguration', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectCustomConfiguration', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateMobileNotifiers
     *
     * Reserved
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\MobileNotifierConfigurationInformation $mobile_notifier_configuration_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\MobileNotifierConfigurationInformation
     */
    public function updateMobileNotifiers($account_id, $mobile_notifier_configuration_information = null)
    {
        list($response) = $this->updateMobileNotifiersWithHttpInfo($account_id, $mobile_notifier_configuration_information);
        return $response;
    }

    /**
     * Operation updateMobileNotifiersWithHttpInfo
     *
     * Reserved
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\MobileNotifierConfigurationInformation $mobile_notifier_configuration_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\MobileNotifierConfigurationInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateMobileNotifiersWithHttpInfo($account_id, $mobile_notifier_configuration_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateMobileNotifiers');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/connect/mobile_notifiers";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($mobile_notifier_configuration_information)) {
            $_tempBody = $mobile_notifier_configuration_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation',
                '/v2/accounts/{accountId}/connect/mobile_notifiers'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
