<?php
/**
 * NotaryHost
 *
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;

/**
 * NotaryHost Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class NotaryHost implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'notaryHost';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'access_code' => 'string',
        'add_access_code_to_email' => 'string',
        'client_user_id' => 'string',
        'custom_fields' => 'string[]',
        'declined_date_time' => 'string',
        'declined_reason' => 'string',
        'delivered_date_time' => 'string',
        'delivery_method' => 'string',
        'document_visibility' => '\DocuSign\eSign\Model\DocumentVisibility[]',
        'email' => 'string',
        'email_notification' => '\DocuSign\eSign\Model\RecipientEmailNotification',
        'embedded_recipient_start_url' => 'string',
        'error_details' => '\DocuSign\eSign\Model\ErrorDetails',
        'fax_number' => 'string',
        'host_recipient_id' => 'string',
        'id_check_configuration_name' => 'string',
        'id_check_information_input' => '\DocuSign\eSign\Model\IdCheckInformationInput',
        'inherit_email_notification_configuration' => 'string',
        'name' => 'string',
        'notary_email_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'notary_name_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'note' => 'string',
        'phone_authentication' => '\DocuSign\eSign\Model\RecipientPhoneAuthentication',
        'recipient_attachments' => '\DocuSign\eSign\Model\RecipientAttachment[]',
        'recipient_authentication_status' => '\DocuSign\eSign\Model\AuthenticationStatus',
        'recipient_id' => 'string',
        'recipient_id_guid' => 'string',
        'require_id_lookup' => 'string',
        'role_name' => 'string',
        'routing_order' => 'string',
        'saml_authentication' => '\DocuSign\eSign\Model\RecipientSAMLAuthentication',
        'sent_date_time' => 'string',
        'signed_date_time' => 'string',
        'sms_authentication' => '\DocuSign\eSign\Model\RecipientSMSAuthentication',
        'social_authentications' => '\DocuSign\eSign\Model\SocialAuthentication[]',
        'status' => 'string',
        'template_locked' => 'string',
        'template_required' => 'string',
        'total_tab_count' => 'string',
        'user_id' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'access_code' => 'accessCode',
        'add_access_code_to_email' => 'addAccessCodeToEmail',
        'client_user_id' => 'clientUserId',
        'custom_fields' => 'customFields',
        'declined_date_time' => 'declinedDateTime',
        'declined_reason' => 'declinedReason',
        'delivered_date_time' => 'deliveredDateTime',
        'delivery_method' => 'deliveryMethod',
        'document_visibility' => 'documentVisibility',
        'email' => 'email',
        'email_notification' => 'emailNotification',
        'embedded_recipient_start_url' => 'embeddedRecipientStartURL',
        'error_details' => 'errorDetails',
        'fax_number' => 'faxNumber',
        'host_recipient_id' => 'hostRecipientId',
        'id_check_configuration_name' => 'idCheckConfigurationName',
        'id_check_information_input' => 'idCheckInformationInput',
        'inherit_email_notification_configuration' => 'inheritEmailNotificationConfiguration',
        'name' => 'name',
        'notary_email_metadata' => 'notaryEmailMetadata',
        'notary_name_metadata' => 'notaryNameMetadata',
        'note' => 'note',
        'phone_authentication' => 'phoneAuthentication',
        'recipient_attachments' => 'recipientAttachments',
        'recipient_authentication_status' => 'recipientAuthenticationStatus',
        'recipient_id' => 'recipientId',
        'recipient_id_guid' => 'recipientIdGuid',
        'require_id_lookup' => 'requireIdLookup',
        'role_name' => 'roleName',
        'routing_order' => 'routingOrder',
        'saml_authentication' => 'samlAuthentication',
        'sent_date_time' => 'sentDateTime',
        'signed_date_time' => 'signedDateTime',
        'sms_authentication' => 'smsAuthentication',
        'social_authentications' => 'socialAuthentications',
        'status' => 'status',
        'template_locked' => 'templateLocked',
        'template_required' => 'templateRequired',
        'total_tab_count' => 'totalTabCount',
        'user_id' => 'userId'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'access_code' => 'setAccessCode',
        'add_access_code_to_email' => 'setAddAccessCodeToEmail',
        'client_user_id' => 'setClientUserId',
        'custom_fields' => 'setCustomFields',
        'declined_date_time' => 'setDeclinedDateTime',
        'declined_reason' => 'setDeclinedReason',
        'delivered_date_time' => 'setDeliveredDateTime',
        'delivery_method' => 'setDeliveryMethod',
        'document_visibility' => 'setDocumentVisibility',
        'email' => 'setEmail',
        'email_notification' => 'setEmailNotification',
        'embedded_recipient_start_url' => 'setEmbeddedRecipientStartUrl',
        'error_details' => 'setErrorDetails',
        'fax_number' => 'setFaxNumber',
        'host_recipient_id' => 'setHostRecipientId',
        'id_check_configuration_name' => 'setIdCheckConfigurationName',
        'id_check_information_input' => 'setIdCheckInformationInput',
        'inherit_email_notification_configuration' => 'setInheritEmailNotificationConfiguration',
        'name' => 'setName',
        'notary_email_metadata' => 'setNotaryEmailMetadata',
        'notary_name_metadata' => 'setNotaryNameMetadata',
        'note' => 'setNote',
        'phone_authentication' => 'setPhoneAuthentication',
        'recipient_attachments' => 'setRecipientAttachments',
        'recipient_authentication_status' => 'setRecipientAuthenticationStatus',
        'recipient_id' => 'setRecipientId',
        'recipient_id_guid' => 'setRecipientIdGuid',
        'require_id_lookup' => 'setRequireIdLookup',
        'role_name' => 'setRoleName',
        'routing_order' => 'setRoutingOrder',
        'saml_authentication' => 'setSamlAuthentication',
        'sent_date_time' => 'setSentDateTime',
        'signed_date_time' => 'setSignedDateTime',
        'sms_authentication' => 'setSmsAuthentication',
        'social_authentications' => 'setSocialAuthentications',
        'status' => 'setStatus',
        'template_locked' => 'setTemplateLocked',
        'template_required' => 'setTemplateRequired',
        'total_tab_count' => 'setTotalTabCount',
        'user_id' => 'setUserId'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'access_code' => 'getAccessCode',
        'add_access_code_to_email' => 'getAddAccessCodeToEmail',
        'client_user_id' => 'getClientUserId',
        'custom_fields' => 'getCustomFields',
        'declined_date_time' => 'getDeclinedDateTime',
        'declined_reason' => 'getDeclinedReason',
        'delivered_date_time' => 'getDeliveredDateTime',
        'delivery_method' => 'getDeliveryMethod',
        'document_visibility' => 'getDocumentVisibility',
        'email' => 'getEmail',
        'email_notification' => 'getEmailNotification',
        'embedded_recipient_start_url' => 'getEmbeddedRecipientStartUrl',
        'error_details' => 'getErrorDetails',
        'fax_number' => 'getFaxNumber',
        'host_recipient_id' => 'getHostRecipientId',
        'id_check_configuration_name' => 'getIdCheckConfigurationName',
        'id_check_information_input' => 'getIdCheckInformationInput',
        'inherit_email_notification_configuration' => 'getInheritEmailNotificationConfiguration',
        'name' => 'getName',
        'notary_email_metadata' => 'getNotaryEmailMetadata',
        'notary_name_metadata' => 'getNotaryNameMetadata',
        'note' => 'getNote',
        'phone_authentication' => 'getPhoneAuthentication',
        'recipient_attachments' => 'getRecipientAttachments',
        'recipient_authentication_status' => 'getRecipientAuthenticationStatus',
        'recipient_id' => 'getRecipientId',
        'recipient_id_guid' => 'getRecipientIdGuid',
        'require_id_lookup' => 'getRequireIdLookup',
        'role_name' => 'getRoleName',
        'routing_order' => 'getRoutingOrder',
        'saml_authentication' => 'getSamlAuthentication',
        'sent_date_time' => 'getSentDateTime',
        'signed_date_time' => 'getSignedDateTime',
        'sms_authentication' => 'getSmsAuthentication',
        'social_authentications' => 'getSocialAuthentications',
        'status' => 'getStatus',
        'template_locked' => 'getTemplateLocked',
        'template_required' => 'getTemplateRequired',
        'total_tab_count' => 'getTotalTabCount',
        'user_id' => 'getUserId'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['access_code'] = isset($data['access_code']) ? $data['access_code'] : null;
        $this->container['add_access_code_to_email'] = isset($data['add_access_code_to_email']) ? $data['add_access_code_to_email'] : null;
        $this->container['client_user_id'] = isset($data['client_user_id']) ? $data['client_user_id'] : null;
        $this->container['custom_fields'] = isset($data['custom_fields']) ? $data['custom_fields'] : null;
        $this->container['declined_date_time'] = isset($data['declined_date_time']) ? $data['declined_date_time'] : null;
        $this->container['declined_reason'] = isset($data['declined_reason']) ? $data['declined_reason'] : null;
        $this->container['delivered_date_time'] = isset($data['delivered_date_time']) ? $data['delivered_date_time'] : null;
        $this->container['delivery_method'] = isset($data['delivery_method']) ? $data['delivery_method'] : null;
        $this->container['document_visibility'] = isset($data['document_visibility']) ? $data['document_visibility'] : null;
        $this->container['email'] = isset($data['email']) ? $data['email'] : null;
        $this->container['email_notification'] = isset($data['email_notification']) ? $data['email_notification'] : null;
        $this->container['embedded_recipient_start_url'] = isset($data['embedded_recipient_start_url']) ? $data['embedded_recipient_start_url'] : null;
        $this->container['error_details'] = isset($data['error_details']) ? $data['error_details'] : null;
        $this->container['fax_number'] = isset($data['fax_number']) ? $data['fax_number'] : null;
        $this->container['host_recipient_id'] = isset($data['host_recipient_id']) ? $data['host_recipient_id'] : null;
        $this->container['id_check_configuration_name'] = isset($data['id_check_configuration_name']) ? $data['id_check_configuration_name'] : null;
        $this->container['id_check_information_input'] = isset($data['id_check_information_input']) ? $data['id_check_information_input'] : null;
        $this->container['inherit_email_notification_configuration'] = isset($data['inherit_email_notification_configuration']) ? $data['inherit_email_notification_configuration'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['notary_email_metadata'] = isset($data['notary_email_metadata']) ? $data['notary_email_metadata'] : null;
        $this->container['notary_name_metadata'] = isset($data['notary_name_metadata']) ? $data['notary_name_metadata'] : null;
        $this->container['note'] = isset($data['note']) ? $data['note'] : null;
        $this->container['phone_authentication'] = isset($data['phone_authentication']) ? $data['phone_authentication'] : null;
        $this->container['recipient_attachments'] = isset($data['recipient_attachments']) ? $data['recipient_attachments'] : null;
        $this->container['recipient_authentication_status'] = isset($data['recipient_authentication_status']) ? $data['recipient_authentication_status'] : null;
        $this->container['recipient_id'] = isset($data['recipient_id']) ? $data['recipient_id'] : null;
        $this->container['recipient_id_guid'] = isset($data['recipient_id_guid']) ? $data['recipient_id_guid'] : null;
        $this->container['require_id_lookup'] = isset($data['require_id_lookup']) ? $data['require_id_lookup'] : null;
        $this->container['role_name'] = isset($data['role_name']) ? $data['role_name'] : null;
        $this->container['routing_order'] = isset($data['routing_order']) ? $data['routing_order'] : null;
        $this->container['saml_authentication'] = isset($data['saml_authentication']) ? $data['saml_authentication'] : null;
        $this->container['sent_date_time'] = isset($data['sent_date_time']) ? $data['sent_date_time'] : null;
        $this->container['signed_date_time'] = isset($data['signed_date_time']) ? $data['signed_date_time'] : null;
        $this->container['sms_authentication'] = isset($data['sms_authentication']) ? $data['sms_authentication'] : null;
        $this->container['social_authentications'] = isset($data['social_authentications']) ? $data['social_authentications'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['template_locked'] = isset($data['template_locked']) ? $data['template_locked'] : null;
        $this->container['template_required'] = isset($data['template_required']) ? $data['template_required'] : null;
        $this->container['total_tab_count'] = isset($data['total_tab_count']) ? $data['total_tab_count'] : null;
        $this->container['user_id'] = isset($data['user_id']) ? $data['user_id'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets access_code
     * @return string
     */
    public function getAccessCode()
    {
        return $this->container['access_code'];
    }

    /**
     * Sets access_code
     * @param string $access_code If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account’s access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.
     * @return $this
     */
    public function setAccessCode($access_code)
    {
        $this->container['access_code'] = $access_code;

        return $this;
    }

    /**
     * Gets add_access_code_to_email
     * @return string
     */
    public function getAddAccessCodeToEmail()
    {
        return $this->container['add_access_code_to_email'];
    }

    /**
     * Sets add_access_code_to_email
     * @param string $add_access_code_to_email This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.
     * @return $this
     */
    public function setAddAccessCodeToEmail($add_access_code_to_email)
    {
        $this->container['add_access_code_to_email'] = $add_access_code_to_email;

        return $this;
    }

    /**
     * Gets client_user_id
     * @return string
     */
    public function getClientUserId()
    {
        return $this->container['client_user_id'];
    }

    /**
     * Sets client_user_id
     * @param string $client_user_id Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters.
     * @return $this
     */
    public function setClientUserId($client_user_id)
    {
        $this->container['client_user_id'] = $client_user_id;

        return $this;
    }

    /**
     * Gets custom_fields
     * @return string[]
     */
    public function getCustomFields()
    {
        return $this->container['custom_fields'];
    }

    /**
     * Sets custom_fields
     * @param string[] $custom_fields An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.
     * @return $this
     */
    public function setCustomFields($custom_fields)
    {
        $this->container['custom_fields'] = $custom_fields;

        return $this;
    }

    /**
     * Gets declined_date_time
     * @return string
     */
    public function getDeclinedDateTime()
    {
        return $this->container['declined_date_time'];
    }

    /**
     * Sets declined_date_time
     * @param string $declined_date_time The date and time the recipient declined the document.
     * @return $this
     */
    public function setDeclinedDateTime($declined_date_time)
    {
        $this->container['declined_date_time'] = $declined_date_time;

        return $this;
    }

    /**
     * Gets declined_reason
     * @return string
     */
    public function getDeclinedReason()
    {
        return $this->container['declined_reason'];
    }

    /**
     * Sets declined_reason
     * @param string $declined_reason The reason the recipient declined the document.
     * @return $this
     */
    public function setDeclinedReason($declined_reason)
    {
        $this->container['declined_reason'] = $declined_reason;

        return $this;
    }

    /**
     * Gets delivered_date_time
     * @return string
     */
    public function getDeliveredDateTime()
    {
        return $this->container['delivered_date_time'];
    }

    /**
     * Sets delivered_date_time
     * @param string $delivered_date_time Reserved: For DocuSign use only.
     * @return $this
     */
    public function setDeliveredDateTime($delivered_date_time)
    {
        $this->container['delivered_date_time'] = $delivered_date_time;

        return $this;
    }

    /**
     * Gets delivery_method
     * @return string
     */
    public function getDeliveryMethod()
    {
        return $this->container['delivery_method'];
    }

    /**
     * Sets delivery_method
     * @param string $delivery_method Reserved: For DocuSign use only.
     * @return $this
     */
    public function setDeliveryMethod($delivery_method)
    {
        $this->container['delivery_method'] = $delivery_method;

        return $this;
    }

    /**
     * Gets document_visibility
     * @return \DocuSign\eSign\Model\DocumentVisibility[]
     */
    public function getDocumentVisibility()
    {
        return $this->container['document_visibility'];
    }

    /**
     * Sets document_visibility
     * @param \DocuSign\eSign\Model\DocumentVisibility[] $document_visibility 
     * @return $this
     */
    public function setDocumentVisibility($document_visibility)
    {
        $this->container['document_visibility'] = $document_visibility;

        return $this;
    }

    /**
     * Gets email
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     * @param string $email 
     * @return $this
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets email_notification
     * @return \DocuSign\eSign\Model\RecipientEmailNotification
     */
    public function getEmailNotification()
    {
        return $this->container['email_notification'];
    }

    /**
     * Sets email_notification
     * @param \DocuSign\eSign\Model\RecipientEmailNotification $email_notification
     * @return $this
     */
    public function setEmailNotification($email_notification)
    {
        $this->container['email_notification'] = $email_notification;

        return $this;
    }

    /**
     * Gets embedded_recipient_start_url
     * @return string
     */
    public function getEmbeddedRecipientStartUrl()
    {
        return $this->container['embedded_recipient_start_url'];
    }

    /**
     * Sets embedded_recipient_start_url
     * @param string $embedded_recipient_start_url Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender’s system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient’s identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]`
     * @return $this
     */
    public function setEmbeddedRecipientStartUrl($embedded_recipient_start_url)
    {
        $this->container['embedded_recipient_start_url'] = $embedded_recipient_start_url;

        return $this;
    }

    /**
     * Gets error_details
     * @return \DocuSign\eSign\Model\ErrorDetails
     */
    public function getErrorDetails()
    {
        return $this->container['error_details'];
    }

    /**
     * Sets error_details
     * @param \DocuSign\eSign\Model\ErrorDetails $error_details
     * @return $this
     */
    public function setErrorDetails($error_details)
    {
        $this->container['error_details'] = $error_details;

        return $this;
    }

    /**
     * Gets fax_number
     * @return string
     */
    public function getFaxNumber()
    {
        return $this->container['fax_number'];
    }

    /**
     * Sets fax_number
     * @param string $fax_number Reserved:
     * @return $this
     */
    public function setFaxNumber($fax_number)
    {
        $this->container['fax_number'] = $fax_number;

        return $this;
    }

    /**
     * Gets host_recipient_id
     * @return string
     */
    public function getHostRecipientId()
    {
        return $this->container['host_recipient_id'];
    }

    /**
     * Sets host_recipient_id
     * @param string $host_recipient_id 
     * @return $this
     */
    public function setHostRecipientId($host_recipient_id)
    {
        $this->container['host_recipient_id'] = $host_recipient_id;

        return $this;
    }

    /**
     * Gets id_check_configuration_name
     * @return string
     */
    public function getIdCheckConfigurationName()
    {
        return $this->container['id_check_configuration_name'];
    }

    /**
     * Sets id_check_configuration_name
     * @param string $id_check_configuration_name Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.
     * @return $this
     */
    public function setIdCheckConfigurationName($id_check_configuration_name)
    {
        $this->container['id_check_configuration_name'] = $id_check_configuration_name;

        return $this;
    }

    /**
     * Gets id_check_information_input
     * @return \DocuSign\eSign\Model\IdCheckInformationInput
     */
    public function getIdCheckInformationInput()
    {
        return $this->container['id_check_information_input'];
    }

    /**
     * Sets id_check_information_input
     * @param \DocuSign\eSign\Model\IdCheckInformationInput $id_check_information_input
     * @return $this
     */
    public function setIdCheckInformationInput($id_check_information_input)
    {
        $this->container['id_check_information_input'] = $id_check_information_input;

        return $this;
    }

    /**
     * Gets inherit_email_notification_configuration
     * @return string
     */
    public function getInheritEmailNotificationConfiguration()
    {
        return $this->container['inherit_email_notification_configuration'];
    }

    /**
     * Sets inherit_email_notification_configuration
     * @param string $inherit_email_notification_configuration When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account.
     * @return $this
     */
    public function setInheritEmailNotificationConfiguration($inherit_email_notification_configuration)
    {
        $this->container['inherit_email_notification_configuration'] = $inherit_email_notification_configuration;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name 
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets notary_email_metadata
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getNotaryEmailMetadata()
    {
        return $this->container['notary_email_metadata'];
    }

    /**
     * Sets notary_email_metadata
     * @param \DocuSign\eSign\Model\PropertyMetadata $notary_email_metadata
     * @return $this
     */
    public function setNotaryEmailMetadata($notary_email_metadata)
    {
        $this->container['notary_email_metadata'] = $notary_email_metadata;

        return $this;
    }

    /**
     * Gets notary_name_metadata
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getNotaryNameMetadata()
    {
        return $this->container['notary_name_metadata'];
    }

    /**
     * Sets notary_name_metadata
     * @param \DocuSign\eSign\Model\PropertyMetadata $notary_name_metadata
     * @return $this
     */
    public function setNotaryNameMetadata($notary_name_metadata)
    {
        $this->container['notary_name_metadata'] = $notary_name_metadata;

        return $this;
    }

    /**
     * Gets note
     * @return string
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     * @param string $note Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.
     * @return $this
     */
    public function setNote($note)
    {
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets phone_authentication
     * @return \DocuSign\eSign\Model\RecipientPhoneAuthentication
     */
    public function getPhoneAuthentication()
    {
        return $this->container['phone_authentication'];
    }

    /**
     * Sets phone_authentication
     * @param \DocuSign\eSign\Model\RecipientPhoneAuthentication $phone_authentication
     * @return $this
     */
    public function setPhoneAuthentication($phone_authentication)
    {
        $this->container['phone_authentication'] = $phone_authentication;

        return $this;
    }

    /**
     * Gets recipient_attachments
     * @return \DocuSign\eSign\Model\RecipientAttachment[]
     */
    public function getRecipientAttachments()
    {
        return $this->container['recipient_attachments'];
    }

    /**
     * Sets recipient_attachments
     * @param \DocuSign\eSign\Model\RecipientAttachment[] $recipient_attachments Reserved:
     * @return $this
     */
    public function setRecipientAttachments($recipient_attachments)
    {
        $this->container['recipient_attachments'] = $recipient_attachments;

        return $this;
    }

    /**
     * Gets recipient_authentication_status
     * @return \DocuSign\eSign\Model\AuthenticationStatus
     */
    public function getRecipientAuthenticationStatus()
    {
        return $this->container['recipient_authentication_status'];
    }

    /**
     * Sets recipient_authentication_status
     * @param \DocuSign\eSign\Model\AuthenticationStatus $recipient_authentication_status
     * @return $this
     */
    public function setRecipientAuthenticationStatus($recipient_authentication_status)
    {
        $this->container['recipient_authentication_status'] = $recipient_authentication_status;

        return $this;
    }

    /**
     * Gets recipient_id
     * @return string
     */
    public function getRecipientId()
    {
        return $this->container['recipient_id'];
    }

    /**
     * Sets recipient_id
     * @param string $recipient_id Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.
     * @return $this
     */
    public function setRecipientId($recipient_id)
    {
        $this->container['recipient_id'] = $recipient_id;

        return $this;
    }

    /**
     * Gets recipient_id_guid
     * @return string
     */
    public function getRecipientIdGuid()
    {
        return $this->container['recipient_id_guid'];
    }

    /**
     * Sets recipient_id_guid
     * @param string $recipient_id_guid 
     * @return $this
     */
    public function setRecipientIdGuid($recipient_id_guid)
    {
        $this->container['recipient_id_guid'] = $recipient_id_guid;

        return $this;
    }

    /**
     * Gets require_id_lookup
     * @return string
     */
    public function getRequireIdLookup()
    {
        return $this->container['require_id_lookup'];
    }

    /**
     * Sets require_id_lookup
     * @param string $require_id_lookup When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity.
     * @return $this
     */
    public function setRequireIdLookup($require_id_lookup)
    {
        $this->container['require_id_lookup'] = $require_id_lookup;

        return $this;
    }

    /**
     * Gets role_name
     * @return string
     */
    public function getRoleName()
    {
        return $this->container['role_name'];
    }

    /**
     * Sets role_name
     * @param string $role_name Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.
     * @return $this
     */
    public function setRoleName($role_name)
    {
        $this->container['role_name'] = $role_name;

        return $this;
    }

    /**
     * Gets routing_order
     * @return string
     */
    public function getRoutingOrder()
    {
        return $this->container['routing_order'];
    }

    /**
     * Sets routing_order
     * @param string $routing_order Specifies the routing order of the recipient in the envelope.
     * @return $this
     */
    public function setRoutingOrder($routing_order)
    {
        $this->container['routing_order'] = $routing_order;

        return $this;
    }

    /**
     * Gets saml_authentication
     * @return \DocuSign\eSign\Model\RecipientSAMLAuthentication
     */
    public function getSamlAuthentication()
    {
        return $this->container['saml_authentication'];
    }

    /**
     * Sets saml_authentication
     * @param \DocuSign\eSign\Model\RecipientSAMLAuthentication $saml_authentication
     * @return $this
     */
    public function setSamlAuthentication($saml_authentication)
    {
        $this->container['saml_authentication'] = $saml_authentication;

        return $this;
    }

    /**
     * Gets sent_date_time
     * @return string
     */
    public function getSentDateTime()
    {
        return $this->container['sent_date_time'];
    }

    /**
     * Sets sent_date_time
     * @param string $sent_date_time The date and time the envelope was sent.
     * @return $this
     */
    public function setSentDateTime($sent_date_time)
    {
        $this->container['sent_date_time'] = $sent_date_time;

        return $this;
    }

    /**
     * Gets signed_date_time
     * @return string
     */
    public function getSignedDateTime()
    {
        return $this->container['signed_date_time'];
    }

    /**
     * Sets signed_date_time
     * @param string $signed_date_time Reserved: For DocuSign use only.
     * @return $this
     */
    public function setSignedDateTime($signed_date_time)
    {
        $this->container['signed_date_time'] = $signed_date_time;

        return $this;
    }

    /**
     * Gets sms_authentication
     * @return \DocuSign\eSign\Model\RecipientSMSAuthentication
     */
    public function getSmsAuthentication()
    {
        return $this->container['sms_authentication'];
    }

    /**
     * Sets sms_authentication
     * @param \DocuSign\eSign\Model\RecipientSMSAuthentication $sms_authentication
     * @return $this
     */
    public function setSmsAuthentication($sms_authentication)
    {
        $this->container['sms_authentication'] = $sms_authentication;

        return $this;
    }

    /**
     * Gets social_authentications
     * @return \DocuSign\eSign\Model\SocialAuthentication[]
     */
    public function getSocialAuthentications()
    {
        return $this->container['social_authentications'];
    }

    /**
     * Sets social_authentications
     * @param \DocuSign\eSign\Model\SocialAuthentication[] $social_authentications Lists the social ID type that can be used for recipient authentication.
     * @return $this
     */
    public function setSocialAuthentications($social_authentications)
    {
        $this->container['social_authentications'] = $social_authentications;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets template_locked
     * @return string
     */
    public function getTemplateLocked()
    {
        return $this->container['template_locked'];
    }

    /**
     * Sets template_locked
     * @param string $template_locked When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients.
     * @return $this
     */
    public function setTemplateLocked($template_locked)
    {
        $this->container['template_locked'] = $template_locked;

        return $this;
    }

    /**
     * Gets template_required
     * @return string
     */
    public function getTemplateRequired()
    {
        return $this->container['template_required'];
    }

    /**
     * Sets template_required
     * @param string $template_required When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.
     * @return $this
     */
    public function setTemplateRequired($template_required)
    {
        $this->container['template_required'] = $template_required;

        return $this;
    }

    /**
     * Gets total_tab_count
     * @return string
     */
    public function getTotalTabCount()
    {
        return $this->container['total_tab_count'];
    }

    /**
     * Sets total_tab_count
     * @param string $total_tab_count 
     * @return $this
     */
    public function setTotalTabCount($total_tab_count)
    {
        $this->container['total_tab_count'] = $total_tab_count;

        return $this;
    }

    /**
     * Gets user_id
     * @return string
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     * @param string $user_id 
     * @return $this
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this));
    }
}


