<?php
/**
 * EnvelopesApi
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\EnvelopesApi;

class CreateEnvelopeOptions
{
    /**
      * $cdse_mode 
      * @var string
      */
    protected $cdse_mode;

    /**
     * Gets cdse_mode
     * @return string
     */
    public function getCdseMode()
    {
        return $this->cdse_mode;
    }
  
    /**
     * Sets cdse_mode
     * @param string $cdse_mode 
     * @return $this
     */
    public function setCdseMode($cdse_mode)
    {
        $this->cdse_mode = $cdse_mode;
        return $this;
    }
    /**
      * $completed_documents_only If set to true then we want to set the sourceEnvelopeId to indicate that this is a\"forward\" envelope action
      * @var string
      */
    protected $completed_documents_only;

    /**
     * Gets completed_documents_only
     * @return string
     */
    public function getCompletedDocumentsOnly()
    {
        return $this->completed_documents_only;
    }
  
    /**
     * Sets completed_documents_only
     * @param string $completed_documents_only If set to true then we want to set the sourceEnvelopeId to indicate that this is a\"forward\" envelope action
     * @return $this
     */
    public function setCompletedDocumentsOnly($completed_documents_only)
    {
        $this->completed_documents_only = $completed_documents_only;
        return $this;
    }
    /**
      * $merge_roles_on_draft When set to **true**, merges template roles and remove empty recipients when you create an envelope with multiple templates.
      * @var string
      */
    protected $merge_roles_on_draft;

    /**
     * Gets merge_roles_on_draft
     * @return string
     */
    public function getMergeRolesOnDraft()
    {
        return $this->merge_roles_on_draft;
    }
  
    /**
     * Sets merge_roles_on_draft
     * @param string $merge_roles_on_draft When set to **true**, merges template roles and remove empty recipients when you create an envelope with multiple templates.
     * @return $this
     */
    public function setMergeRolesOnDraft($merge_roles_on_draft)
    {
        $this->merge_roles_on_draft = $merge_roles_on_draft;
        return $this;
    }
}
class CreateRecipientOptions
{
    /**
      * $resend_envelope When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope’s next recipient.
      * @var string
      */
    protected $resend_envelope;

    /**
     * Gets resend_envelope
     * @return string
     */
    public function getResendEnvelope()
    {
        return $this->resend_envelope;
    }
  
    /**
     * Sets resend_envelope
     * @param string $resend_envelope When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope’s next recipient.
     * @return $this
     */
    public function setResendEnvelope($resend_envelope)
    {
        $this->resend_envelope = $resend_envelope;
        return $this;
    }
}
class GetChunkedUploadOptions
{
    /**
      * $include 
      * @var string
      */
    protected $include;

    /**
     * Gets include
     * @return string
     */
    public function getInclude()
    {
        return $this->include;
    }
  
    /**
     * Sets include
     * @param string $include 
     * @return $this
     */
    public function setInclude($include)
    {
        $this->include = $include;
        return $this;
    }
}
class GetConsumerDisclosureOptions
{
    /**
      * $lang_code2 
      * @var string
      */
    protected $lang_code2;

    /**
     * Gets lang_code2
     * @return string
     */
    public function getLangCode2()
    {
        return $this->lang_code2;
    }
  
    /**
     * Sets lang_code2
     * @param string $lang_code2 
     * @return $this
     */
    public function setLangCode2($lang_code2)
    {
        $this->lang_code2 = $lang_code2;
        return $this;
    }
}
class GetConsumerDisclosureDefaultOptions
{
    /**
      * $lang_code 
      * @var string
      */
    protected $lang_code;

    /**
     * Gets lang_code
     * @return string
     */
    public function getLangCode()
    {
        return $this->lang_code;
    }
  
    /**
     * Sets lang_code
     * @param string $lang_code 
     * @return $this
     */
    public function setLangCode($lang_code)
    {
        $this->lang_code = $lang_code;
        return $this;
    }
}
class GetDocumentOptions
{
    /**
      * $certificate When set to **false**, the envelope signing certificate is removed from the download.
      * @var string
      */
    protected $certificate;

    /**
     * Gets certificate
     * @return string
     */
    public function getCertificate()
    {
        return $this->certificate;
    }
  
    /**
     * Sets certificate
     * @param string $certificate When set to **false**, the envelope signing certificate is removed from the download.
     * @return $this
     */
    public function setCertificate($certificate)
    {
        $this->certificate = $certificate;
        return $this;
    }
    /**
      * $encoding 
      * @var string
      */
    protected $encoding;

    /**
     * Gets encoding
     * @return string
     */
    public function getEncoding()
    {
        return $this->encoding;
    }
  
    /**
     * Sets encoding
     * @param string $encoding 
     * @return $this
     */
    public function setEncoding($encoding)
    {
        $this->encoding = $encoding;
        return $this;
    }
    /**
      * $encrypt When set to **true**, the PDF bytes returned in the response are encrypted for all the key managers configured on your DocuSign account. The documents can be decrypted with the KeyManager Decrypt Document API.
      * @var string
      */
    protected $encrypt;

    /**
     * Gets encrypt
     * @return string
     */
    public function getEncrypt()
    {
        return $this->encrypt;
    }
  
    /**
     * Sets encrypt
     * @param string $encrypt When set to **true**, the PDF bytes returned in the response are encrypted for all the key managers configured on your DocuSign account. The documents can be decrypted with the KeyManager Decrypt Document API.
     * @return $this
     */
    public function setEncrypt($encrypt)
    {
        $this->encrypt = $encrypt;
        return $this;
    }
    /**
      * $language Specifies the language for the Certificate of Completion in the response. The supported languages, with the language value shown in parenthesis, are: Chinese Simplified (zh_CN), , Chinese Traditional (zh_TW), Dutch (nl), English US (en), French (fr), German (de), Italian (it), Japanese (ja), Korean (ko), Portuguese (pt), Portuguese (Brazil) (pt_BR), Russian (ru), Spanish (es).
      * @var string
      */
    protected $language;

    /**
     * Gets language
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
  
    /**
     * Sets language
     * @param string $language Specifies the language for the Certificate of Completion in the response. The supported languages, with the language value shown in parenthesis, are: Chinese Simplified (zh_CN), , Chinese Traditional (zh_TW), Dutch (nl), English US (en), French (fr), German (de), Italian (it), Japanese (ja), Korean (ko), Portuguese (pt), Portuguese (Brazil) (pt_BR), Russian (ru), Spanish (es).
     * @return $this
     */
    public function setLanguage($language)
    {
        $this->language = $language;
        return $this;
    }
    /**
      * $recipient_id 
      * @var string
      */
    protected $recipient_id;

    /**
     * Gets recipient_id
     * @return string
     */
    public function getRecipientId()
    {
        return $this->recipient_id;
    }
  
    /**
     * Sets recipient_id
     * @param string $recipient_id 
     * @return $this
     */
    public function setRecipientId($recipient_id)
    {
        $this->recipient_id = $recipient_id;
        return $this;
    }
    /**
      * $show_changes When set to **true**, any changed fields for the returned PDF are highlighted in yellow and optional signatures or initials outlined in red.
      * @var string
      */
    protected $show_changes;

    /**
     * Gets show_changes
     * @return string
     */
    public function getShowChanges()
    {
        return $this->show_changes;
    }
  
    /**
     * Sets show_changes
     * @param string $show_changes When set to **true**, any changed fields for the returned PDF are highlighted in yellow and optional signatures or initials outlined in red.
     * @return $this
     */
    public function setShowChanges($show_changes)
    {
        $this->show_changes = $show_changes;
        return $this;
    }
    /**
      * $watermark When set to **true**, the account has the watermark feature enabled, and the envelope is not complete, the watermark for the account is added to the PDF documents. This option can remove the watermark.
      * @var string
      */
    protected $watermark;

    /**
     * Gets watermark
     * @return string
     */
    public function getWatermark()
    {
        return $this->watermark;
    }
  
    /**
     * Sets watermark
     * @param string $watermark When set to **true**, the account has the watermark feature enabled, and the envelope is not complete, the watermark for the account is added to the PDF documents. This option can remove the watermark.
     * @return $this
     */
    public function setWatermark($watermark)
    {
        $this->watermark = $watermark;
        return $this;
    }
}
class GetDocumentPageImageOptions
{
    /**
      * $dpi Sets the dpi for the image.
      * @var string
      */
    protected $dpi;

    /**
     * Gets dpi
     * @return string
     */
    public function getDpi()
    {
        return $this->dpi;
    }
  
    /**
     * Sets dpi
     * @param string $dpi Sets the dpi for the image.
     * @return $this
     */
    public function setDpi($dpi)
    {
        $this->dpi = $dpi;
        return $this;
    }
    /**
      * $max_height Sets the maximum height for the page image in pixels. The dpi is recalculated based on this setting.
      * @var string
      */
    protected $max_height;

    /**
     * Gets max_height
     * @return string
     */
    public function getMaxHeight()
    {
        return $this->max_height;
    }
  
    /**
     * Sets max_height
     * @param string $max_height Sets the maximum height for the page image in pixels. The dpi is recalculated based on this setting.
     * @return $this
     */
    public function setMaxHeight($max_height)
    {
        $this->max_height = $max_height;
        return $this;
    }
    /**
      * $max_width Sets the maximum width for the page image in pixels. The dpi is recalculated based on this setting.
      * @var string
      */
    protected $max_width;

    /**
     * Gets max_width
     * @return string
     */
    public function getMaxWidth()
    {
        return $this->max_width;
    }
  
    /**
     * Sets max_width
     * @param string $max_width Sets the maximum width for the page image in pixels. The dpi is recalculated based on this setting.
     * @return $this
     */
    public function setMaxWidth($max_width)
    {
        $this->max_width = $max_width;
        return $this;
    }
    /**
      * $show_changes 
      * @var string
      */
    protected $show_changes;

    /**
     * Gets show_changes
     * @return string
     */
    public function getShowChanges()
    {
        return $this->show_changes;
    }
  
    /**
     * Sets show_changes
     * @param string $show_changes 
     * @return $this
     */
    public function setShowChanges($show_changes)
    {
        $this->show_changes = $show_changes;
        return $this;
    }
}
class GetEnvelopeOptions
{
    /**
      * $advanced_update When true, envelope information can be added or modified.
      * @var string
      */
    protected $advanced_update;

    /**
     * Gets advanced_update
     * @return string
     */
    public function getAdvancedUpdate()
    {
        return $this->advanced_update;
    }
  
    /**
     * Sets advanced_update
     * @param string $advanced_update When true, envelope information can be added or modified.
     * @return $this
     */
    public function setAdvancedUpdate($advanced_update)
    {
        $this->advanced_update = $advanced_update;
        return $this;
    }
    /**
      * $include 
      * @var string
      */
    protected $include;

    /**
     * Gets include
     * @return string
     */
    public function getInclude()
    {
        return $this->include;
    }
  
    /**
     * Sets include
     * @param string $include 
     * @return $this
     */
    public function setInclude($include)
    {
        $this->include = $include;
        return $this;
    }
}
class GetRecipientInitialsImageOptions
{
    /**
      * $include_chrome The added line and identifier around the initial image. Note: Older envelopes might only have chromed images. If getting the non-chromed image fails, try getting the chromed image.
      * @var string
      */
    protected $include_chrome;

    /**
     * Gets include_chrome
     * @return string
     */
    public function getIncludeChrome()
    {
        return $this->include_chrome;
    }
  
    /**
     * Sets include_chrome
     * @param string $include_chrome The added line and identifier around the initial image. Note: Older envelopes might only have chromed images. If getting the non-chromed image fails, try getting the chromed image.
     * @return $this
     */
    public function setIncludeChrome($include_chrome)
    {
        $this->include_chrome = $include_chrome;
        return $this;
    }
}
class GetRecipientSignatureImageOptions
{
    /**
      * $include_chrome When set to **true**, indicates the chromed version of the signature image should be retrieved.
      * @var string
      */
    protected $include_chrome;

    /**
     * Gets include_chrome
     * @return string
     */
    public function getIncludeChrome()
    {
        return $this->include_chrome;
    }
  
    /**
     * Sets include_chrome
     * @param string $include_chrome When set to **true**, indicates the chromed version of the signature image should be retrieved.
     * @return $this
     */
    public function setIncludeChrome($include_chrome)
    {
        $this->include_chrome = $include_chrome;
        return $this;
    }
}
class ListDocumentsOptions
{
    /**
      * $include_metadata 
      * @var string
      */
    protected $include_metadata;

    /**
     * Gets include_metadata
     * @return string
     */
    public function getIncludeMetadata()
    {
        return $this->include_metadata;
    }
  
    /**
     * Sets include_metadata
     * @param string $include_metadata 
     * @return $this
     */
    public function setIncludeMetadata($include_metadata)
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
}
class ListRecipientsOptions
{
    /**
      * $include_anchor_tab_locations When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response.
      * @var string
      */
    protected $include_anchor_tab_locations;

    /**
     * Gets include_anchor_tab_locations
     * @return string
     */
    public function getIncludeAnchorTabLocations()
    {
        return $this->include_anchor_tab_locations;
    }
  
    /**
     * Sets include_anchor_tab_locations
     * @param string $include_anchor_tab_locations When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response.
     * @return $this
     */
    public function setIncludeAnchorTabLocations($include_anchor_tab_locations)
    {
        $this->include_anchor_tab_locations = $include_anchor_tab_locations;
        return $this;
    }
    /**
      * $include_extended When set to **true**, the extended properties are included in the response.
      * @var string
      */
    protected $include_extended;

    /**
     * Gets include_extended
     * @return string
     */
    public function getIncludeExtended()
    {
        return $this->include_extended;
    }
  
    /**
     * Sets include_extended
     * @param string $include_extended When set to **true**, the extended properties are included in the response.
     * @return $this
     */
    public function setIncludeExtended($include_extended)
    {
        $this->include_extended = $include_extended;
        return $this;
    }
    /**
      * $include_metadata 
      * @var string
      */
    protected $include_metadata;

    /**
     * Gets include_metadata
     * @return string
     */
    public function getIncludeMetadata()
    {
        return $this->include_metadata;
    }
  
    /**
     * Sets include_metadata
     * @param string $include_metadata 
     * @return $this
     */
    public function setIncludeMetadata($include_metadata)
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
    /**
      * $include_tabs When set to **true**, the tab information associated with the recipient is included in the response.
      * @var string
      */
    protected $include_tabs;

    /**
     * Gets include_tabs
     * @return string
     */
    public function getIncludeTabs()
    {
        return $this->include_tabs;
    }
  
    /**
     * Sets include_tabs
     * @param string $include_tabs When set to **true**, the tab information associated with the recipient is included in the response.
     * @return $this
     */
    public function setIncludeTabs($include_tabs)
    {
        $this->include_tabs = $include_tabs;
        return $this;
    }
}
class ListStatusOptions
{
    /**
      * $email 
      * @var string
      */
    protected $email;

    /**
     * Gets email
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
  
    /**
     * Sets email
     * @param string $email 
     * @return $this
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }
    /**
      * $from_date 
      * @var string
      */
    protected $from_date;

    /**
     * Gets from_date
     * @return string
     */
    public function getFromDate()
    {
        return $this->from_date;
    }
  
    /**
     * Sets from_date
     * @param string $from_date 
     * @return $this
     */
    public function setFromDate($from_date)
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $start_position 
      * @var string
      */
    protected $start_position;

    /**
     * Gets start_position
     * @return string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }
  
    /**
     * Sets start_position
     * @param string $start_position 
     * @return $this
     */
    public function setStartPosition($start_position)
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $to_date 
      * @var string
      */
    protected $to_date;

    /**
     * Gets to_date
     * @return string
     */
    public function getToDate()
    {
        return $this->to_date;
    }
  
    /**
     * Sets to_date
     * @param string $to_date 
     * @return $this
     */
    public function setToDate($to_date)
    {
        $this->to_date = $to_date;
        return $this;
    }
}
class ListStatusChangesOptions
{
    /**
      * $ac_status Specifies the Authoritative Copy Status for the envelopes. The possible values are: Unknown, Original, Transferred, AuthoritativeCopy, AuthoritativeCopyExportPending, AuthoritativeCopyExported, DepositPending, Deposited, DepositedEO, or DepositFailed.
      * @var string
      */
    protected $ac_status;

    /**
     * Gets ac_status
     * @return string
     */
    public function getAcStatus()
    {
        return $this->ac_status;
    }
  
    /**
     * Sets ac_status
     * @param string $ac_status Specifies the Authoritative Copy Status for the envelopes. The possible values are: Unknown, Original, Transferred, AuthoritativeCopy, AuthoritativeCopyExportPending, AuthoritativeCopyExported, DepositPending, Deposited, DepositedEO, or DepositFailed.
     * @return $this
     */
    public function setAcStatus($ac_status)
    {
        $this->ac_status = $ac_status;
        return $this;
    }
    /**
      * $block 
      * @var string
      */
    protected $block;

    /**
     * Gets block
     * @return string
     */
    public function getBlock()
    {
        return $this->block;
    }
  
    /**
     * Sets block
     * @param string $block 
     * @return $this
     */
    public function setBlock($block)
    {
        $this->block = $block;
        return $this;
    }
    /**
      * $count 
      * @var string
      */
    protected $count;

    /**
     * Gets count
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }
  
    /**
     * Sets count
     * @param string $count 
     * @return $this
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $custom_field This specifies the envelope custom field name and value searched for in the envelope information. The value portion of the query can use partial strings by adding '%' (percent sign) around the custom field query value.   Example 1: If you have an envelope custom field called \"Region\" and you want to search for all envelopes where the value is \"West\" you would use the query: `?custom_field=Region=West`.   Example 2: To search for envelopes where the `ApplicationID` custom field has the value or partial value of \"DocuSign\" in field, the query would be: `?custom_field=ApplicationId=%DocuSign%` This would find envelopes where the custom field value is \"DocuSign for Salesforce\" or \"DocuSign envelope.\"
      * @var string
      */
    protected $custom_field;

    /**
     * Gets custom_field
     * @return string
     */
    public function getCustomField()
    {
        return $this->custom_field;
    }
  
    /**
     * Sets custom_field
     * @param string $custom_field This specifies the envelope custom field name and value searched for in the envelope information. The value portion of the query can use partial strings by adding '%' (percent sign) around the custom field query value.   Example 1: If you have an envelope custom field called \"Region\" and you want to search for all envelopes where the value is \"West\" you would use the query: `?custom_field=Region=West`.   Example 2: To search for envelopes where the `ApplicationID` custom field has the value or partial value of \"DocuSign\" in field, the query would be: `?custom_field=ApplicationId=%DocuSign%` This would find envelopes where the custom field value is \"DocuSign for Salesforce\" or \"DocuSign envelope.\"
     * @return $this
     */
    public function setCustomField($custom_field)
    {
        $this->custom_field = $custom_field;
        return $this;
    }
    /**
      * $email 
      * @var string
      */
    protected $email;

    /**
     * Gets email
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
  
    /**
     * Sets email
     * @param string $email 
     * @return $this
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }
    /**
      * $envelope_ids 
      * @var string
      */
    protected $envelope_ids;

    /**
     * Gets envelope_ids
     * @return string
     */
    public function getEnvelopeIds()
    {
        return $this->envelope_ids;
    }
  
    /**
     * Sets envelope_ids
     * @param string $envelope_ids 
     * @return $this
     */
    public function setEnvelopeIds($envelope_ids)
    {
        $this->envelope_ids = $envelope_ids;
        return $this;
    }
    /**
      * $exclude 
      * @var string
      */
    protected $exclude;

    /**
     * Gets exclude
     * @return string
     */
    public function getExclude()
    {
        return $this->exclude;
    }
  
    /**
     * Sets exclude
     * @param string $exclude 
     * @return $this
     */
    public function setExclude($exclude)
    {
        $this->exclude = $exclude;
        return $this;
    }
    /**
      * $folder_ids 
      * @var string
      */
    protected $folder_ids;

    /**
     * Gets folder_ids
     * @return string
     */
    public function getFolderIds()
    {
        return $this->folder_ids;
    }
  
    /**
     * Sets folder_ids
     * @param string $folder_ids 
     * @return $this
     */
    public function setFolderIds($folder_ids)
    {
        $this->folder_ids = $folder_ids;
        return $this;
    }
    /**
      * $folder_types 
      * @var string
      */
    protected $folder_types;

    /**
     * Gets folder_types
     * @return string
     */
    public function getFolderTypes()
    {
        return $this->folder_types;
    }
  
    /**
     * Sets folder_types
     * @param string $folder_types 
     * @return $this
     */
    public function setFolderTypes($folder_types)
    {
        $this->folder_types = $folder_types;
        return $this;
    }
    /**
      * $from_date The date/time setting that specifies the date/time when the request begins checking for status changes for envelopes in the account.  This is required unless 'envelopeId's are used.
      * @var string
      */
    protected $from_date;

    /**
     * Gets from_date
     * @return string
     */
    public function getFromDate()
    {
        return $this->from_date;
    }
  
    /**
     * Sets from_date
     * @param string $from_date The date/time setting that specifies the date/time when the request begins checking for status changes for envelopes in the account.  This is required unless 'envelopeId's are used.
     * @return $this
     */
    public function setFromDate($from_date)
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $from_to_status This is the status type checked for in the `from_date`/`to_date` period. If `changed` is specified, then envelopes that changed status during the period are found. If for example, `created` is specified, then envelopes created during the period are found. Default is `changed`.   Possible values are: Voided, Changed, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
      * @var string
      */
    protected $from_to_status;

    /**
     * Gets from_to_status
     * @return string
     */
    public function getFromToStatus()
    {
        return $this->from_to_status;
    }
  
    /**
     * Sets from_to_status
     * @param string $from_to_status This is the status type checked for in the `from_date`/`to_date` period. If `changed` is specified, then envelopes that changed status during the period are found. If for example, `created` is specified, then envelopes created during the period are found. Default is `changed`.   Possible values are: Voided, Changed, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
     * @return $this
     */
    public function setFromToStatus($from_to_status)
    {
        $this->from_to_status = $from_to_status;
        return $this;
    }
    /**
      * $include 
      * @var string
      */
    protected $include;

    /**
     * Gets include
     * @return string
     */
    public function getInclude()
    {
        return $this->include;
    }
  
    /**
     * Sets include
     * @param string $include 
     * @return $this
     */
    public function setInclude($include)
    {
        $this->include = $include;
        return $this;
    }
    /**
      * $intersecting_folder_ids 
      * @var string
      */
    protected $intersecting_folder_ids;

    /**
     * Gets intersecting_folder_ids
     * @return string
     */
    public function getIntersectingFolderIds()
    {
        return $this->intersecting_folder_ids;
    }
  
    /**
     * Sets intersecting_folder_ids
     * @param string $intersecting_folder_ids 
     * @return $this
     */
    public function setIntersectingFolderIds($intersecting_folder_ids)
    {
        $this->intersecting_folder_ids = $intersecting_folder_ids;
        return $this;
    }
    /**
      * $order 
      * @var string
      */
    protected $order;

    /**
     * Gets order
     * @return string
     */
    public function getOrder()
    {
        return $this->order;
    }
  
    /**
     * Sets order
     * @param string $order 
     * @return $this
     */
    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }
    /**
      * $order_by 
      * @var string
      */
    protected $order_by;

    /**
     * Gets order_by
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }
  
    /**
     * Sets order_by
     * @param string $order_by 
     * @return $this
     */
    public function setOrderBy($order_by)
    {
        $this->order_by = $order_by;
        return $this;
    }
    /**
      * $powerformids 
      * @var string
      */
    protected $powerformids;

    /**
     * Gets powerformids
     * @return string
     */
    public function getPowerformids()
    {
        return $this->powerformids;
    }
  
    /**
     * Sets powerformids
     * @param string $powerformids 
     * @return $this
     */
    public function setPowerformids($powerformids)
    {
        $this->powerformids = $powerformids;
        return $this;
    }
    /**
      * $search_text 
      * @var string
      */
    protected $search_text;

    /**
     * Gets search_text
     * @return string
     */
    public function getSearchText()
    {
        return $this->search_text;
    }
  
    /**
     * Sets search_text
     * @param string $search_text 
     * @return $this
     */
    public function setSearchText($search_text)
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $start_position 
      * @var string
      */
    protected $start_position;

    /**
     * Gets start_position
     * @return string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }
  
    /**
     * Sets start_position
     * @param string $start_position 
     * @return $this
     */
    public function setStartPosition($start_position)
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $status The list of current statuses to include in the response. By default, all envelopes found are returned. If values are specified, then of the envelopes found, only those with the current status specified are returned in the results.   Possible values are: Voided, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
      * @var string
      */
    protected $status;

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
  
    /**
     * Sets status
     * @param string $status The list of current statuses to include in the response. By default, all envelopes found are returned. If values are specified, then of the envelopes found, only those with the current status specified are returned in the results.   Possible values are: Voided, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
     * @return $this
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }
    /**
      * $to_date Optional date/time setting that specifies the date/time when the request stops for status changes for envelopes in the account. If no entry, the system uses the time of the call as the `to_date`.
      * @var string
      */
    protected $to_date;

    /**
     * Gets to_date
     * @return string
     */
    public function getToDate()
    {
        return $this->to_date;
    }
  
    /**
     * Sets to_date
     * @param string $to_date Optional date/time setting that specifies the date/time when the request stops for status changes for envelopes in the account. If no entry, the system uses the time of the call as the `to_date`.
     * @return $this
     */
    public function setToDate($to_date)
    {
        $this->to_date = $to_date;
        return $this;
    }
    /**
      * $transaction_ids If included in the query string, this is a comma separated list of envelope `transactionId`s.   If included in the `request_body`, this is a list of envelope `transactionId`s.   ###### Note: `transactionId`s are only valid in the DocuSign system for seven days.
      * @var string
      */
    protected $transaction_ids;

    /**
     * Gets transaction_ids
     * @return string
     */
    public function getTransactionIds()
    {
        return $this->transaction_ids;
    }
  
    /**
     * Sets transaction_ids
     * @param string $transaction_ids If included in the query string, this is a comma separated list of envelope `transactionId`s.   If included in the `request_body`, this is a list of envelope `transactionId`s.   ###### Note: `transactionId`s are only valid in the DocuSign system for seven days.
     * @return $this
     */
    public function setTransactionIds($transaction_ids)
    {
        $this->transaction_ids = $transaction_ids;
        return $this;
    }
    /**
      * $user_filter 
      * @var string
      */
    protected $user_filter;

    /**
     * Gets user_filter
     * @return string
     */
    public function getUserFilter()
    {
        return $this->user_filter;
    }
  
    /**
     * Sets user_filter
     * @param string $user_filter 
     * @return $this
     */
    public function setUserFilter($user_filter)
    {
        $this->user_filter = $user_filter;
        return $this;
    }
    /**
      * $user_id 
      * @var string
      */
    protected $user_id;

    /**
     * Gets user_id
     * @return string
     */
    public function getUserId()
    {
        return $this->user_id;
    }
  
    /**
     * Sets user_id
     * @param string $user_id 
     * @return $this
     */
    public function setUserId($user_id)
    {
        $this->user_id = $user_id;
        return $this;
    }
    /**
      * $user_name 
      * @var string
      */
    protected $user_name;

    /**
     * Gets user_name
     * @return string
     */
    public function getUserName()
    {
        return $this->user_name;
    }
  
    /**
     * Sets user_name
     * @param string $user_name 
     * @return $this
     */
    public function setUserName($user_name)
    {
        $this->user_name = $user_name;
        return $this;
    }
}
class ListTabsOptions
{
    /**
      * $include_anchor_tab_locations When set to **true**, all tabs with anchor tab properties are included in the response.
      * @var string
      */
    protected $include_anchor_tab_locations;

    /**
     * Gets include_anchor_tab_locations
     * @return string
     */
    public function getIncludeAnchorTabLocations()
    {
        return $this->include_anchor_tab_locations;
    }
  
    /**
     * Sets include_anchor_tab_locations
     * @param string $include_anchor_tab_locations When set to **true**, all tabs with anchor tab properties are included in the response.
     * @return $this
     */
    public function setIncludeAnchorTabLocations($include_anchor_tab_locations)
    {
        $this->include_anchor_tab_locations = $include_anchor_tab_locations;
        return $this;
    }
    /**
      * $include_metadata 
      * @var string
      */
    protected $include_metadata;

    /**
     * Gets include_metadata
     * @return string
     */
    public function getIncludeMetadata()
    {
        return $this->include_metadata;
    }
  
    /**
     * Sets include_metadata
     * @param string $include_metadata 
     * @return $this
     */
    public function setIncludeMetadata($include_metadata)
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
}
class ListTemplatesOptions
{
    /**
      * $include The possible values are:  matching_applied – This returns template matching information for the template.
      * @var string
      */
    protected $include;

    /**
     * Gets include
     * @return string
     */
    public function getInclude()
    {
        return $this->include;
    }
  
    /**
     * Sets include
     * @param string $include The possible values are:  matching_applied – This returns template matching information for the template.
     * @return $this
     */
    public function setInclude($include)
    {
        $this->include = $include;
        return $this;
    }
}
class ListTemplatesForDocumentOptions
{
    /**
      * $include 
      * @var string
      */
    protected $include;

    /**
     * Gets include
     * @return string
     */
    public function getInclude()
    {
        return $this->include;
    }
  
    /**
     * Sets include
     * @param string $include 
     * @return $this
     */
    public function setInclude($include)
    {
        $this->include = $include;
        return $this;
    }
}
class UpdateOptions
{
    /**
      * $advanced_update When set to **true**, allows the caller to update recipients, tabs, custom fields, notification, email settings and other envelope attributes.
      * @var string
      */
    protected $advanced_update;

    /**
     * Gets advanced_update
     * @return string
     */
    public function getAdvancedUpdate()
    {
        return $this->advanced_update;
    }
  
    /**
     * Sets advanced_update
     * @param string $advanced_update When set to **true**, allows the caller to update recipients, tabs, custom fields, notification, email settings and other envelope attributes.
     * @return $this
     */
    public function setAdvancedUpdate($advanced_update)
    {
        $this->advanced_update = $advanced_update;
        return $this;
    }
    /**
      * $resend_envelope When set to **true**, sends the specified envelope again.
      * @var string
      */
    protected $resend_envelope;

    /**
     * Gets resend_envelope
     * @return string
     */
    public function getResendEnvelope()
    {
        return $this->resend_envelope;
    }
  
    /**
     * Sets resend_envelope
     * @param string $resend_envelope When set to **true**, sends the specified envelope again.
     * @return $this
     */
    public function setResendEnvelope($resend_envelope)
    {
        $this->resend_envelope = $resend_envelope;
        return $this;
    }
}
class UpdateChunkedUploadOptions
{
    /**
      * $action 
      * @var string
      */
    protected $action;

    /**
     * Gets action
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }
  
    /**
     * Sets action
     * @param string $action 
     * @return $this
     */
    public function setAction($action)
    {
        $this->action = $action;
        return $this;
    }
}
class UpdateDocumentOptions
{
    /**
      * $apply_document_fields 
      * @var string
      */
    protected $apply_document_fields;

    /**
     * Gets apply_document_fields
     * @return string
     */
    public function getApplyDocumentFields()
    {
        return $this->apply_document_fields;
    }
  
    /**
     * Sets apply_document_fields
     * @param string $apply_document_fields 
     * @return $this
     */
    public function setApplyDocumentFields($apply_document_fields)
    {
        $this->apply_document_fields = $apply_document_fields;
        return $this;
    }
}
class UpdateDocumentsOptions
{
    /**
      * $apply_document_fields When true, Document fields can be added or modified while adding or modifying envelope documents.
      * @var string
      */
    protected $apply_document_fields;

    /**
     * Gets apply_document_fields
     * @return string
     */
    public function getApplyDocumentFields()
    {
        return $this->apply_document_fields;
    }
  
    /**
     * Sets apply_document_fields
     * @param string $apply_document_fields When true, Document fields can be added or modified while adding or modifying envelope documents.
     * @return $this
     */
    public function setApplyDocumentFields($apply_document_fields)
    {
        $this->apply_document_fields = $apply_document_fields;
        return $this;
    }
}
class UpdateRecipientsOptions
{
    /**
      * $resend_envelope When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope’s next recipient.
      * @var string
      */
    protected $resend_envelope;

    /**
     * Gets resend_envelope
     * @return string
     */
    public function getResendEnvelope()
    {
        return $this->resend_envelope;
    }
  
    /**
     * Sets resend_envelope
     * @param string $resend_envelope When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope’s next recipient.
     * @return $this
     */
    public function setResendEnvelope($resend_envelope)
    {
        $this->resend_envelope = $resend_envelope;
        return $this;
    }
}


namespace DocuSign\eSign\Api;

use \DocuSign\eSign\ApiClient;
use \DocuSign\eSign\ApiException;
use \DocuSign\eSign\Configuration;
use \DocuSign\eSign\ObjectSerializer;

/**
 * EnvelopesApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class EnvelopesApi
{
    /**
     * API Client
     *
     * @var \DocuSign\eSign\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \DocuSign\eSign\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\DocuSign\eSign\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \DocuSign\eSign\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \DocuSign\eSign\ApiClient $apiClient set the API client
     *
     * @return EnvelopesApi
     */
    public function setApiClient(\DocuSign\eSign\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation applyTemplate
     *
     * Adds templates to an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentTemplateList $document_template_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentTemplateList
     */
    public function applyTemplate($account_id, $envelope_id, $document_template_list = null)
    {
        list($response) = $this->applyTemplateWithHttpInfo($account_id, $envelope_id, $document_template_list);
        return $response;
    }

    /**
     * Operation applyTemplateWithHttpInfo
     *
     * Adds templates to an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentTemplateList $document_template_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentTemplateList, HTTP status code, HTTP response headers (array of strings)
     */
    public function applyTemplateWithHttpInfo($account_id, $envelope_id, $document_template_list = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling applyTemplate');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling applyTemplate');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/templates";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($document_template_list)) {
            $_tempBody = $document_template_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentTemplateList',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentTemplateList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentTemplateList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation applyTemplateToDocument
     *
     * Adds templates to a document in an  envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentTemplateList $document_template_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentTemplateList
     */
    public function applyTemplateToDocument($account_id, $document_id, $envelope_id, $document_template_list = null)
    {
        list($response) = $this->applyTemplateToDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $document_template_list);
        return $response;
    }

    /**
     * Operation applyTemplateToDocumentWithHttpInfo
     *
     * Adds templates to a document in an  envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentTemplateList $document_template_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentTemplateList, HTTP status code, HTTP response headers (array of strings)
     */
    public function applyTemplateToDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $document_template_list = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling applyTemplateToDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling applyTemplateToDocument');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling applyTemplateToDocument');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($document_template_list)) {
            $_tempBody = $document_template_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentTemplateList',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentTemplateList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentTemplateList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createChunkedUpload
     *
     * Initiate a new ChunkedUpload.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ChunkedUploadRequest $chunked_upload_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ChunkedUploadResponse
     */
    public function createChunkedUpload($account_id, $chunked_upload_request = null)
    {
        list($response) = $this->createChunkedUploadWithHttpInfo($account_id, $chunked_upload_request);
        return $response;
    }

    /**
     * Operation createChunkedUploadWithHttpInfo
     *
     * Initiate a new ChunkedUpload.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ChunkedUploadRequest $chunked_upload_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ChunkedUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createChunkedUploadWithHttpInfo($account_id, $chunked_upload_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createChunkedUpload');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/chunked_uploads";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($chunked_upload_request)) {
            $_tempBody = $chunked_upload_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ChunkedUploadResponse',
                '/v2/accounts/{accountId}/chunked_uploads'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ChunkedUploadResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ChunkedUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createConsoleView
     *
     * Returns a URL to the authentication view UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConsoleViewRequest $console_view_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createConsoleView($account_id, $console_view_request = null)
    {
        list($response) = $this->createConsoleViewWithHttpInfo($account_id, $console_view_request);
        return $response;
    }

    /**
     * Operation createConsoleViewWithHttpInfo
     *
     * Returns a URL to the authentication view UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConsoleViewRequest $console_view_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createConsoleViewWithHttpInfo($account_id, $console_view_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createConsoleView');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/views/console";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($console_view_request)) {
            $_tempBody = $console_view_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2/accounts/{accountId}/views/console'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createCorrectView
     *
     * Returns a URL to the envelope correction UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CorrectViewRequest $correct_view_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createCorrectView($account_id, $envelope_id, $correct_view_request = null)
    {
        list($response) = $this->createCorrectViewWithHttpInfo($account_id, $envelope_id, $correct_view_request);
        return $response;
    }

    /**
     * Operation createCorrectViewWithHttpInfo
     *
     * Returns a URL to the envelope correction UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CorrectViewRequest $correct_view_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCorrectViewWithHttpInfo($account_id, $envelope_id, $correct_view_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createCorrectView');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createCorrectView');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/correct";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($correct_view_request)) {
            $_tempBody = $correct_view_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/views/correct'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createCustomFields
     *
     * Updates envelope custom fields for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function createCustomFields($account_id, $envelope_id, $custom_fields = null)
    {
        list($response) = $this->createCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields);
        return $response;
    }

    /**
     * Operation createCustomFieldsWithHttpInfo
     *
     * Updates envelope custom fields for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createCustomFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($custom_fields)) {
            $_tempBody = $custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createDocumentFields
     *
     * Creates custom document fields in an existing envelope document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function createDocumentFields($account_id, $document_id, $envelope_id, $document_fields_information = null)
    {
        list($response) = $this->createDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation createDocumentFieldsWithHttpInfo
     *
     * Creates custom document fields in an existing envelope document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling createDocumentFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEditView
     *
     * Returns a URL to the edit view UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ReturnUrlRequest $return_url_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createEditView($account_id, $envelope_id, $return_url_request = null)
    {
        list($response) = $this->createEditViewWithHttpInfo($account_id, $envelope_id, $return_url_request);
        return $response;
    }

    /**
     * Operation createEditViewWithHttpInfo
     *
     * Returns a URL to the edit view UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ReturnUrlRequest $return_url_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEditViewWithHttpInfo($account_id, $envelope_id, $return_url_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEditView');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createEditView');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/edit";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($return_url_request)) {
            $_tempBody = $return_url_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/views/edit'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEmailSettings
     *
     * Adds email setting overrides to an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EmailSettings $email_settings  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EmailSettings
     */
    public function createEmailSettings($account_id, $envelope_id, $email_settings = null)
    {
        list($response) = $this->createEmailSettingsWithHttpInfo($account_id, $envelope_id, $email_settings);
        return $response;
    }

    /**
     * Operation createEmailSettingsWithHttpInfo
     *
     * Adds email setting overrides to an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EmailSettings $email_settings  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EmailSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmailSettingsWithHttpInfo($account_id, $envelope_id, $email_settings = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEmailSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createEmailSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($email_settings)) {
            $_tempBody = $email_settings;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EmailSettings',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EmailSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EmailSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEnvelope
     *
     * Creates an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeSummary
     */
    public function createEnvelope($account_id, $envelope_definition = null, EnvelopesApi\CreateEnvelopeOptions $options = null)
    {
        list($response) = $this->createEnvelopeWithHttpInfo($account_id, $envelope_definition, $options);
        return $response;
    }

    /**
     * Operation createEnvelopeWithHttpInfo
     *
     * Creates an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEnvelopeWithHttpInfo($account_id, $envelope_definition = null, EnvelopesApi\CreateEnvelopeOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEnvelope');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getCdseMode() !== null) {
            $queryParams['cdse_mode'] = $this->apiClient->getSerializer()->toQueryValue($options->getCdseMode());
        }
        // query params
        if ($options->getCompletedDocumentsOnly() !== null) {
            $queryParams['completed_documents_only'] = $this->apiClient->getSerializer()->toQueryValue($options->getCompletedDocumentsOnly());
        }
        // query params
        if ($options->getMergeRolesOnDraft() !== null) {
            $queryParams['merge_roles_on_draft'] = $this->apiClient->getSerializer()->toQueryValue($options->getMergeRolesOnDraft());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeSummary',
                '/v2/accounts/{accountId}/envelopes'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createLock
     *
     * Lock an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function createLock($account_id, $envelope_id, $lock_request = null)
    {
        list($response) = $this->createLockWithHttpInfo($account_id, $envelope_id, $lock_request);
        return $response;
    }

    /**
     * Operation createLockWithHttpInfo
     *
     * Lock an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLockWithHttpInfo($account_id, $envelope_id, $lock_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createLock');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createLock');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($lock_request)) {
            $_tempBody = $lock_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createRecipient
     *
     * Adds one or more recipients to an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function createRecipient($account_id, $envelope_id, $recipients = null, EnvelopesApi\CreateRecipientOptions $options = null)
    {
        list($response) = $this->createRecipientWithHttpInfo($account_id, $envelope_id, $recipients, $options);
        return $response;
    }

    /**
     * Operation createRecipientWithHttpInfo
     *
     * Adds one or more recipients to an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRecipientWithHttpInfo($account_id, $envelope_id, $recipients = null, EnvelopesApi\CreateRecipientOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createRecipient');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createRecipient');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getResendEnvelope() !== null) {
            $queryParams['resend_envelope'] = $this->apiClient->getSerializer()->toQueryValue($options->getResendEnvelope());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($recipients)) {
            $_tempBody = $recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createRecipientView
     *
     * Returns a URL to the recipient view UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\RecipientViewRequest $recipient_view_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createRecipientView($account_id, $envelope_id, $recipient_view_request = null)
    {
        list($response) = $this->createRecipientViewWithHttpInfo($account_id, $envelope_id, $recipient_view_request);
        return $response;
    }

    /**
     * Operation createRecipientViewWithHttpInfo
     *
     * Returns a URL to the recipient view UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\RecipientViewRequest $recipient_view_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRecipientViewWithHttpInfo($account_id, $envelope_id, $recipient_view_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createRecipientView');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createRecipientView');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/recipient";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($recipient_view_request)) {
            $_tempBody = $recipient_view_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/views/recipient'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createSenderView
     *
     * Returns a URL to the sender view UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ReturnUrlRequest $return_url_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createSenderView($account_id, $envelope_id, $return_url_request = null)
    {
        list($response) = $this->createSenderViewWithHttpInfo($account_id, $envelope_id, $return_url_request);
        return $response;
    }

    /**
     * Operation createSenderViewWithHttpInfo
     *
     * Returns a URL to the sender view UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ReturnUrlRequest $return_url_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSenderViewWithHttpInfo($account_id, $envelope_id, $return_url_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createSenderView');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createSenderView');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/sender";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($return_url_request)) {
            $_tempBody = $return_url_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/views/sender'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createTabs
     *
     * Adds tabs for a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function createTabs($account_id, $envelope_id, $recipient_id, $tabs = null)
    {
        list($response) = $this->createTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs);
        return $response;
    }

    /**
     * Operation createTabsWithHttpInfo
     *
     * Adds tabs for a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling createTabs');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($tabs)) {
            $_tempBody = $tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createViewLink
     *
     * Reserved: Returns a URL to the secure link view UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ViewLinkRequest $view_link_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createViewLink($account_id, $envelope_id, $view_link_request = null)
    {
        list($response) = $this->createViewLinkWithHttpInfo($account_id, $envelope_id, $view_link_request);
        return $response;
    }

    /**
     * Operation createViewLinkWithHttpInfo
     *
     * Reserved: Returns a URL to the secure link view UI.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ViewLinkRequest $view_link_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createViewLinkWithHttpInfo($account_id, $envelope_id, $view_link_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createViewLink');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createViewLink');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/viewlink";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($view_link_request)) {
            $_tempBody = $view_link_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/views/viewlink'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteAttachments
     *
     * Delete one or more attachments from a DRAFT envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeAttachmentsRequest $envelope_attachments_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeAttachmentsResult
     */
    public function deleteAttachments($account_id, $envelope_id, $envelope_attachments_request = null)
    {
        list($response) = $this->deleteAttachmentsWithHttpInfo($account_id, $envelope_id, $envelope_attachments_request);
        return $response;
    }

    /**
     * Operation deleteAttachmentsWithHttpInfo
     *
     * Delete one or more attachments from a DRAFT envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeAttachmentsRequest $envelope_attachments_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeAttachmentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAttachmentsWithHttpInfo($account_id, $envelope_id, $envelope_attachments_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteAttachments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteAttachments');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_attachments_request)) {
            $_tempBody = $envelope_attachments_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeAttachmentsResult',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteChunkedUpload
     *
     * Delete an existing ChunkedUpload.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $chunked_upload_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ChunkedUploadResponse
     */
    public function deleteChunkedUpload($account_id, $chunked_upload_id)
    {
        list($response) = $this->deleteChunkedUploadWithHttpInfo($account_id, $chunked_upload_id);
        return $response;
    }

    /**
     * Operation deleteChunkedUploadWithHttpInfo
     *
     * Delete an existing ChunkedUpload.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $chunked_upload_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ChunkedUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteChunkedUploadWithHttpInfo($account_id, $chunked_upload_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteChunkedUpload');
        }
        // verify the required parameter 'chunked_upload_id' is set
        if ($chunked_upload_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chunked_upload_id when calling deleteChunkedUpload');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($chunked_upload_id !== null) {
            $resourcePath = str_replace(
                "{" . "chunkedUploadId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chunked_upload_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ChunkedUploadResponse',
                '/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ChunkedUploadResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ChunkedUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteCustomFields
     *
     * Deletes envelope custom fields for draft and in-process envelopes.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function deleteCustomFields($account_id, $envelope_id, $custom_fields = null)
    {
        list($response) = $this->deleteCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields);
        return $response;
    }

    /**
     * Operation deleteCustomFieldsWithHttpInfo
     *
     * Deletes envelope custom fields for draft and in-process envelopes.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteCustomFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($custom_fields)) {
            $_tempBody = $custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocumentFields
     *
     * Deletes custom document fields from an existing envelope document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function deleteDocumentFields($account_id, $document_id, $envelope_id, $document_fields_information = null)
    {
        list($response) = $this->deleteDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation deleteDocumentFieldsWithHttpInfo
     *
     * Deletes custom document fields from an existing envelope document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteDocumentFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocumentPage
     *
     * Deletes a page from a document in an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $page_number The page number being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteDocumentPage($account_id, $document_id, $envelope_id, $page_number)
    {
        list($response) = $this->deleteDocumentPageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number);
        return $response;
    }

    /**
     * Operation deleteDocumentPageWithHttpInfo
     *
     * Deletes a page from a document in an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $page_number The page number being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentPageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocumentPage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteDocumentPage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteDocumentPage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling deleteDocumentPage');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = str_replace(
                "{" . "pageNumber" . "}",
                $this->apiClient->getSerializer()->toPathValue($page_number),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocuments
     *
     * Deletes documents from a draft envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeDocumentsResult
     */
    public function deleteDocuments($account_id, $envelope_id, $envelope_definition = null)
    {
        list($response) = $this->deleteDocumentsWithHttpInfo($account_id, $envelope_id, $envelope_definition);
        return $response;
    }

    /**
     * Operation deleteDocumentsWithHttpInfo
     *
     * Deletes documents from a draft envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentsWithHttpInfo($account_id, $envelope_id, $envelope_definition = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocuments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteDocuments');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeDocumentsResult',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEmailSettings
     *
     * Deletes the email setting overrides for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EmailSettings
     */
    public function deleteEmailSettings($account_id, $envelope_id)
    {
        list($response) = $this->deleteEmailSettingsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation deleteEmailSettingsWithHttpInfo
     *
     * Deletes the email setting overrides for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EmailSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEmailSettingsWithHttpInfo($account_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEmailSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteEmailSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EmailSettings',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EmailSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EmailSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteLock
     *
     * Deletes an envelope lock.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function deleteLock($account_id, $envelope_id)
    {
        list($response) = $this->deleteLockWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation deleteLockWithHttpInfo
     *
     * Deletes an envelope lock.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLockWithHttpInfo($account_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteLock');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteLock');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteRecipient
     *
     * Deletes a recipient from an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function deleteRecipient($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->deleteRecipientWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation deleteRecipientWithHttpInfo
     *
     * Deletes a recipient from an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRecipientWithHttpInfo($account_id, $envelope_id, $recipient_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteRecipient');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteRecipient');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling deleteRecipient');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteRecipients
     *
     * Deletes recipients from an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function deleteRecipients($account_id, $envelope_id, $recipients = null)
    {
        list($response) = $this->deleteRecipientsWithHttpInfo($account_id, $envelope_id, $recipients);
        return $response;
    }

    /**
     * Operation deleteRecipientsWithHttpInfo
     *
     * Deletes recipients from an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRecipientsWithHttpInfo($account_id, $envelope_id, $recipients = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteRecipients');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteRecipients');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($recipients)) {
            $_tempBody = $recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteTabs
     *
     * Deletes the tabs associated with a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function deleteTabs($account_id, $envelope_id, $recipient_id, $tabs = null)
    {
        list($response) = $this->deleteTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs);
        return $response;
    }

    /**
     * Operation deleteTabsWithHttpInfo
     *
     * Deletes the tabs associated with a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling deleteTabs');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($tabs)) {
            $_tempBody = $tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteTemplatesFromDocument
     *
     * Deletes a template from a document in an existing envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteTemplatesFromDocument($account_id, $document_id, $envelope_id, $template_id)
    {
        list($response) = $this->deleteTemplatesFromDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $template_id);
        return $response;
    }

    /**
     * Operation deleteTemplatesFromDocumentWithHttpInfo
     *
     * Deletes a template from a document in an existing envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTemplatesFromDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $template_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteTemplatesFromDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteTemplatesFromDocument');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteTemplatesFromDocument');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteTemplatesFromDocument');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates/{templateId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates/{templateId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteViewLink
     *
     * Reserved: Expires a secure view link.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteViewLink($account_id, $envelope_id)
    {
        list($response) = $this->deleteViewLinkWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation deleteViewLinkWithHttpInfo
     *
     * Reserved: Expires a secure view link.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteViewLinkWithHttpInfo($account_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteViewLink');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteViewLink');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/viewlink";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/views/viewlink'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAttachment
     *
     * Retrieves an attachment from the envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $attachment_id 
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function getAttachment($account_id, $attachment_id, $envelope_id)
    {
        list($response) = $this->getAttachmentWithHttpInfo($account_id, $attachment_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getAttachmentWithHttpInfo
     *
     * Retrieves an attachment from the envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $attachment_id 
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAttachmentWithHttpInfo($account_id, $attachment_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAttachment');
        }
        // verify the required parameter 'attachment_id' is set
        if ($attachment_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $attachment_id when calling getAttachment');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getAttachment');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($attachment_id !== null) {
            $resourcePath = str_replace(
                "{" . "attachmentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($attachment_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAttachments
     *
     * Returns a list of attachments associated with the specified envelope
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeAttachmentsResult
     */
    public function getAttachments($account_id, $envelope_id)
    {
        list($response) = $this->getAttachmentsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getAttachmentsWithHttpInfo
     *
     * Returns a list of attachments associated with the specified envelope
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeAttachmentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAttachmentsWithHttpInfo($account_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAttachments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getAttachments');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeAttachmentsResult',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getChunkedUpload
     *
     * Retrieves the current metadata of a ChunkedUpload.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $chunked_upload_id 
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ChunkedUploadResponse
     */
    public function getChunkedUpload($account_id, $chunked_upload_id, EnvelopesApi\GetChunkedUploadOptions $options = null)
    {
        list($response) = $this->getChunkedUploadWithHttpInfo($account_id, $chunked_upload_id, $options);
        return $response;
    }

    /**
     * Operation getChunkedUploadWithHttpInfo
     *
     * Retrieves the current metadata of a ChunkedUpload.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $chunked_upload_id 
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ChunkedUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getChunkedUploadWithHttpInfo($account_id, $chunked_upload_id, EnvelopesApi\GetChunkedUploadOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getChunkedUpload');
        }
        // verify the required parameter 'chunked_upload_id' is set
        if ($chunked_upload_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chunked_upload_id when calling getChunkedUpload');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getInclude() !== null) {
            $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($chunked_upload_id !== null) {
            $resourcePath = str_replace(
                "{" . "chunkedUploadId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chunked_upload_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ChunkedUploadResponse',
                '/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ChunkedUploadResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ChunkedUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConsumerDisclosure
     *
     * Reserved: Gets the Electronic Record and Signature Disclosure associated with the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $lang_code The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to �browser� to automatically detect the browser language being used by the viewer and display the disclosure in that language.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConsumerDisclosure
     */
    public function getConsumerDisclosure($account_id, $envelope_id, $lang_code, $recipient_id, EnvelopesApi\GetConsumerDisclosureOptions $options = null)
    {
        list($response) = $this->getConsumerDisclosureWithHttpInfo($account_id, $envelope_id, $lang_code, $recipient_id, $options);
        return $response;
    }

    /**
     * Operation getConsumerDisclosureWithHttpInfo
     *
     * Reserved: Gets the Electronic Record and Signature Disclosure associated with the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $lang_code The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to �browser� to automatically detect the browser language being used by the viewer and display the disclosure in that language.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConsumerDisclosure, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConsumerDisclosureWithHttpInfo($account_id, $envelope_id, $lang_code, $recipient_id, EnvelopesApi\GetConsumerDisclosureOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConsumerDisclosure');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getConsumerDisclosure');
        }
        // verify the required parameter 'lang_code' is set
        if ($lang_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $lang_code when calling getConsumerDisclosure');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getConsumerDisclosure');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure/{langCode}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getLangCode2() !== null) {
            $queryParams['langCode'] = $this->apiClient->getSerializer()->toQueryValue($options->getLangCode2());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($lang_code !== null) {
            $resourcePath = str_replace(
                "{" . "langCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($lang_code),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConsumerDisclosure',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure/{langCode}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConsumerDisclosure', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConsumerDisclosure', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConsumerDisclosureDefault
     *
     * Gets the Electronic Record and Signature Disclosure associated with the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConsumerDisclosure
     */
    public function getConsumerDisclosureDefault($account_id, $envelope_id, $recipient_id, EnvelopesApi\GetConsumerDisclosureDefaultOptions $options = null)
    {
        list($response) = $this->getConsumerDisclosureDefaultWithHttpInfo($account_id, $envelope_id, $recipient_id, $options);
        return $response;
    }

    /**
     * Operation getConsumerDisclosureDefaultWithHttpInfo
     *
     * Gets the Electronic Record and Signature Disclosure associated with the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConsumerDisclosure, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConsumerDisclosureDefaultWithHttpInfo($account_id, $envelope_id, $recipient_id, EnvelopesApi\GetConsumerDisclosureDefaultOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConsumerDisclosureDefault');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getConsumerDisclosureDefault');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getConsumerDisclosureDefault');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getLangCode() !== null) {
            $queryParams['langCode'] = $this->apiClient->getSerializer()->toQueryValue($options->getLangCode());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConsumerDisclosure',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConsumerDisclosure', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConsumerDisclosure', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDocument
     *
     * Gets a document from an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getDocument($account_id, $document_id, $envelope_id, EnvelopesApi\GetDocumentOptions $options = null)
    {
        list($response) = $this->getDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation getDocumentWithHttpInfo
     *
     * Gets a document from an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDocumentWithHttpInfo($account_id, $document_id, $envelope_id, EnvelopesApi\GetDocumentOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getDocument');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getDocument');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/pdf']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getCertificate() !== null) {
            $queryParams['certificate'] = $this->apiClient->getSerializer()->toQueryValue($options->getCertificate());
        }
        // query params
        if ($options->getEncoding() !== null) {
            $queryParams['encoding'] = $this->apiClient->getSerializer()->toQueryValue($options->getEncoding());
        }
        // query params
        if ($options->getEncrypt() !== null) {
            $queryParams['encrypt'] = $this->apiClient->getSerializer()->toQueryValue($options->getEncrypt());
        }
        // query params
        if ($options->getLanguage() !== null) {
            $queryParams['language'] = $this->apiClient->getSerializer()->toQueryValue($options->getLanguage());
        }
        // query params
        if ($options->getRecipientId() !== null) {
            $queryParams['recipient_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getRecipientId());
        }
        // query params
        if ($options->getShowChanges() !== null) {
            $queryParams['show_changes'] = $this->apiClient->getSerializer()->toQueryValue($options->getShowChanges());
        }
        // query params
        if ($options->getWatermark() !== null) {
            $queryParams['watermark'] = $this->apiClient->getSerializer()->toQueryValue($options->getWatermark());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDocumentPageImage
     *
     * Gets a page image from an envelope for display.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $page_number The page number being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getDocumentPageImage($account_id, $document_id, $envelope_id, $page_number, EnvelopesApi\GetDocumentPageImageOptions $options = null)
    {
        list($response) = $this->getDocumentPageImageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number, $options);
        return $response;
    }

    /**
     * Operation getDocumentPageImageWithHttpInfo
     *
     * Gets a page image from an envelope for display.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $page_number The page number being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDocumentPageImageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number, EnvelopesApi\GetDocumentPageImageOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getDocumentPageImage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getDocumentPageImage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getDocumentPageImage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling getDocumentPageImage');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['image/png']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getDpi() !== null) {
            $queryParams['dpi'] = $this->apiClient->getSerializer()->toQueryValue($options->getDpi());
        }
        // query params
        if ($options->getMaxHeight() !== null) {
            $queryParams['max_height'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxHeight());
        }
        // query params
        if ($options->getMaxWidth() !== null) {
            $queryParams['max_width'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxWidth());
        }
        // query params
        if ($options->getShowChanges() !== null) {
            $queryParams['show_changes'] = $this->apiClient->getSerializer()->toQueryValue($options->getShowChanges());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = str_replace(
                "{" . "pageNumber" . "}",
                $this->apiClient->getSerializer()->toPathValue($page_number),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailSettings
     *
     * Gets the email setting overrides for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EmailSettings
     */
    public function getEmailSettings($account_id, $envelope_id)
    {
        list($response) = $this->getEmailSettingsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getEmailSettingsWithHttpInfo
     *
     * Gets the email setting overrides for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EmailSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmailSettingsWithHttpInfo($account_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEmailSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getEmailSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EmailSettings',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EmailSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EmailSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEnvelope
     *
     * Gets the status of a envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Envelope
     */
    public function getEnvelope($account_id, $envelope_id, EnvelopesApi\GetEnvelopeOptions $options = null)
    {
        list($response) = $this->getEnvelopeWithHttpInfo($account_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation getEnvelopeWithHttpInfo
     *
     * Gets the status of a envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Envelope, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEnvelopeWithHttpInfo($account_id, $envelope_id, EnvelopesApi\GetEnvelopeOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEnvelope');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getEnvelope');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getAdvancedUpdate() !== null) {
            $queryParams['advanced_update'] = $this->apiClient->getSerializer()->toQueryValue($options->getAdvancedUpdate());
        }
        // query params
        if ($options->getInclude() !== null) {
            $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Envelope',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Envelope', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Envelope', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFormData
     *
     * Returns envelope form data for an existing envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeFormData
     */
    public function getFormData($account_id, $envelope_id)
    {
        list($response) = $this->getFormDataWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getFormDataWithHttpInfo
     *
     * Returns envelope form data for an existing envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeFormData, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFormDataWithHttpInfo($account_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getFormData');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getFormData');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/form_data";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeFormData',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/form_data'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeFormData', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeFormData', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLock
     *
     * Gets envelope lock information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function getLock($account_id, $envelope_id)
    {
        list($response) = $this->getLockWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getLockWithHttpInfo
     *
     * Gets envelope lock information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLockWithHttpInfo($account_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getLock');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getLock');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getNotificationSettings
     *
     * Gets envelope notification information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Notification
     */
    public function getNotificationSettings($account_id, $envelope_id)
    {
        list($response) = $this->getNotificationSettingsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getNotificationSettingsWithHttpInfo
     *
     * Gets envelope notification information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Notification, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationSettingsWithHttpInfo($account_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getNotificationSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getNotificationSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/notification";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Notification',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/notification'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Notification', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Notification', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRecipientDocumentVisibility
     *
     * Returns document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentVisibilityList
     */
    public function getRecipientDocumentVisibility($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->getRecipientDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation getRecipientDocumentVisibilityWithHttpInfo
     *
     * Returns document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRecipientDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $recipient_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getRecipientDocumentVisibility');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getRecipientDocumentVisibility');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getRecipientDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentVisibilityList',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRecipientInitialsImage
     *
     * Gets the initials image for a user.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getRecipientInitialsImage($account_id, $envelope_id, $recipient_id, EnvelopesApi\GetRecipientInitialsImageOptions $options = null)
    {
        list($response) = $this->getRecipientInitialsImageWithHttpInfo($account_id, $envelope_id, $recipient_id, $options);
        return $response;
    }

    /**
     * Operation getRecipientInitialsImageWithHttpInfo
     *
     * Gets the initials image for a user.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRecipientInitialsImageWithHttpInfo($account_id, $envelope_id, $recipient_id, EnvelopesApi\GetRecipientInitialsImageOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getRecipientInitialsImage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getRecipientInitialsImage');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getRecipientInitialsImage');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['image/gif']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeChrome() !== null) {
            $queryParams['include_chrome'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeChrome());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRecipientSignature
     *
     * Gets signature information for a signer or sign-in-person recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserSignature
     */
    public function getRecipientSignature($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->getRecipientSignatureWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation getRecipientSignatureWithHttpInfo
     *
     * Gets signature information for a signer or sign-in-person recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserSignature, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRecipientSignatureWithHttpInfo($account_id, $envelope_id, $recipient_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getRecipientSignature');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getRecipientSignature');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getRecipientSignature');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserSignature',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserSignature', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserSignature', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRecipientSignatureImage
     *
     * Retrieve signature image information for a signer/sign-in-person recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getRecipientSignatureImage($account_id, $envelope_id, $recipient_id, EnvelopesApi\GetRecipientSignatureImageOptions $options = null)
    {
        list($response) = $this->getRecipientSignatureImageWithHttpInfo($account_id, $envelope_id, $recipient_id, $options);
        return $response;
    }

    /**
     * Operation getRecipientSignatureImageWithHttpInfo
     *
     * Retrieve signature image information for a signer/sign-in-person recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRecipientSignatureImageWithHttpInfo($account_id, $envelope_id, $recipient_id, EnvelopesApi\GetRecipientSignatureImageOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getRecipientSignatureImage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getRecipientSignatureImage');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getRecipientSignatureImage');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['image/gif']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeChrome() !== null) {
            $queryParams['include_chrome'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeChrome());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getTemplateRecipientDocumentVisibility
     *
     * Returns document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentVisibilityList
     */
    public function getTemplateRecipientDocumentVisibility($account_id, $recipient_id, $template_id)
    {
        list($response) = $this->getTemplateRecipientDocumentVisibilityWithHttpInfo($account_id, $recipient_id, $template_id);
        return $response;
    }

    /**
     * Operation getTemplateRecipientDocumentVisibilityWithHttpInfo
     *
     * Returns document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTemplateRecipientDocumentVisibilityWithHttpInfo($account_id, $recipient_id, $template_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getTemplateRecipientDocumentVisibility');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getTemplateRecipientDocumentVisibility');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getTemplateRecipientDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentVisibilityList',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listAuditEvents
     *
     * Gets the envelope audit events for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeAuditEventResponse
     */
    public function listAuditEvents($account_id, $envelope_id)
    {
        list($response) = $this->listAuditEventsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation listAuditEventsWithHttpInfo
     *
     * Gets the envelope audit events for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeAuditEventResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listAuditEventsWithHttpInfo($account_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listAuditEvents');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listAuditEvents');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/audit_events";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeAuditEventResponse',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/audit_events'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeAuditEventResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeAuditEventResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listCustomFields
     *
     * Gets the custom field information for the specified envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFieldsEnvelope
     */
    public function listCustomFields($account_id, $envelope_id)
    {
        list($response) = $this->listCustomFieldsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation listCustomFieldsWithHttpInfo
     *
     * Gets the custom field information for the specified envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFieldsEnvelope, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCustomFieldsWithHttpInfo($account_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listCustomFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFieldsEnvelope',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFieldsEnvelope', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFieldsEnvelope', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listDocumentFields
     *
     * Gets the custom document fields from an  existing envelope document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function listDocumentFields($account_id, $document_id, $envelope_id)
    {
        list($response) = $this->listDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id);
        return $response;
    }

    /**
     * Operation listDocumentFieldsWithHttpInfo
     *
     * Gets the custom document fields from an  existing envelope document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling listDocumentFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listDocuments
     *
     * Gets a list of envelope documents.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeDocumentsResult
     */
    public function listDocuments($account_id, $envelope_id, EnvelopesApi\ListDocumentsOptions $options = null)
    {
        list($response) = $this->listDocumentsWithHttpInfo($account_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation listDocumentsWithHttpInfo
     *
     * Gets a list of envelope documents.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function listDocumentsWithHttpInfo($account_id, $envelope_id, EnvelopesApi\ListDocumentsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listDocuments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listDocuments');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeMetadata() !== null) {
            $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeDocumentsResult',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listRecipients
     *
     * Gets the status of recipients for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function listRecipients($account_id, $envelope_id, EnvelopesApi\ListRecipientsOptions $options = null)
    {
        list($response) = $this->listRecipientsWithHttpInfo($account_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation listRecipientsWithHttpInfo
     *
     * Gets the status of recipients for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function listRecipientsWithHttpInfo($account_id, $envelope_id, EnvelopesApi\ListRecipientsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listRecipients');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listRecipients');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeAnchorTabLocations() !== null) {
            $queryParams['include_anchor_tab_locations'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeAnchorTabLocations());
        }
        // query params
        if ($options->getIncludeExtended() !== null) {
            $queryParams['include_extended'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeExtended());
        }
        // query params
        if ($options->getIncludeMetadata() !== null) {
            $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
        }
        // query params
        if ($options->getIncludeTabs() !== null) {
            $queryParams['include_tabs'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeTabs());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listStatus
     *
     * Gets the envelope status for the specified envelopes.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeIdsRequest $envelope_ids_request  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopesInformation
     */
    public function listStatus($account_id, $envelope_ids_request = null, EnvelopesApi\ListStatusOptions $options = null)
    {
        list($response) = $this->listStatusWithHttpInfo($account_id, $envelope_ids_request, $options);
        return $response;
    }

    /**
     * Operation listStatusWithHttpInfo
     *
     * Gets the envelope status for the specified envelopes.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeIdsRequest $envelope_ids_request  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopesInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listStatusWithHttpInfo($account_id, $envelope_ids_request = null, EnvelopesApi\ListStatusOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listStatus');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/status";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getEmail() !== null) {
            $queryParams['email'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmail());
        }
        // query params
        if ($options->getFromDate() !== null) {
            $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
        }
        // query params
        if ($options->getStartPosition() !== null) {
            $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
        }
        // query params
        if ($options->getToDate() !== null) {
            $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_ids_request)) {
            $_tempBody = $envelope_ids_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopesInformation',
                '/v2/accounts/{accountId}/envelopes/status'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopesInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopesInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listStatusChanges
     *
     * Gets status changes for one or more envelopes.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopesInformation
     */
    public function listStatusChanges($account_id, EnvelopesApi\ListStatusChangesOptions $options = null)
    {
        list($response) = $this->listStatusChangesWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listStatusChangesWithHttpInfo
     *
     * Gets status changes for one or more envelopes.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopesInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listStatusChangesWithHttpInfo($account_id, EnvelopesApi\ListStatusChangesOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listStatusChanges');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getAcStatus() !== null) {
            $queryParams['ac_status'] = $this->apiClient->getSerializer()->toQueryValue($options->getAcStatus());
        }
        // query params
        if ($options->getBlock() !== null) {
            $queryParams['block'] = $this->apiClient->getSerializer()->toQueryValue($options->getBlock());
        }
        // query params
        if ($options->getCount() !== null) {
            $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
        }
        // query params
        if ($options->getCustomField() !== null) {
            $queryParams['custom_field'] = $this->apiClient->getSerializer()->toQueryValue($options->getCustomField());
        }
        // query params
        if ($options->getEmail() !== null) {
            $queryParams['email'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmail());
        }
        // query params
        if ($options->getEnvelopeIds() !== null) {
            $queryParams['envelope_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getEnvelopeIds());
        }
        // query params
        if ($options->getExclude() !== null) {
            $queryParams['exclude'] = $this->apiClient->getSerializer()->toQueryValue($options->getExclude());
        }
        // query params
        if ($options->getFolderIds() !== null) {
            $queryParams['folder_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getFolderIds());
        }
        // query params
        if ($options->getFolderTypes() !== null) {
            $queryParams['folder_types'] = $this->apiClient->getSerializer()->toQueryValue($options->getFolderTypes());
        }
        // query params
        if ($options->getFromDate() !== null) {
            $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
        }
        // query params
        if ($options->getFromToStatus() !== null) {
            $queryParams['from_to_status'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromToStatus());
        }
        // query params
        if ($options->getInclude() !== null) {
            $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
        }
        // query params
        if ($options->getIntersectingFolderIds() !== null) {
            $queryParams['intersecting_folder_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getIntersectingFolderIds());
        }
        // query params
        if ($options->getOrder() !== null) {
            $queryParams['order'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrder());
        }
        // query params
        if ($options->getOrderBy() !== null) {
            $queryParams['order_by'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrderBy());
        }
        // query params
        if ($options->getPowerformids() !== null) {
            $queryParams['powerformids'] = $this->apiClient->getSerializer()->toQueryValue($options->getPowerformids());
        }
        // query params
        if ($options->getSearchText() !== null) {
            $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
        }
        // query params
        if ($options->getStartPosition() !== null) {
            $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
        }
        // query params
        if ($options->getStatus() !== null) {
            $queryParams['status'] = $this->apiClient->getSerializer()->toQueryValue($options->getStatus());
        }
        // query params
        if ($options->getToDate() !== null) {
            $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
        }
        // query params
        if ($options->getTransactionIds() !== null) {
            $queryParams['transaction_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getTransactionIds());
        }
        // query params
        if ($options->getUserFilter() !== null) {
            $queryParams['user_filter'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserFilter());
        }
        // query params
        if ($options->getUserId() !== null) {
            $queryParams['user_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserId());
        }
        // query params
        if ($options->getUserName() !== null) {
            $queryParams['user_name'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserName());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopesInformation',
                '/v2/accounts/{accountId}/envelopes'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopesInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopesInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listTabs
     *
     * Gets the tabs information for a signer or sign-in-person recipient in an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function listTabs($account_id, $envelope_id, $recipient_id, EnvelopesApi\ListTabsOptions $options = null)
    {
        list($response) = $this->listTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $options);
        return $response;
    }

    /**
     * Operation listTabsWithHttpInfo
     *
     * Gets the tabs information for a signer or sign-in-person recipient in an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, EnvelopesApi\ListTabsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling listTabs');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeAnchorTabLocations() !== null) {
            $queryParams['include_anchor_tab_locations'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeAnchorTabLocations());
        }
        // query params
        if ($options->getIncludeMetadata() !== null) {
            $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listTemplates
     *
     * Get List of Templates used in an Envelope
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateInformation
     */
    public function listTemplates($account_id, $envelope_id, EnvelopesApi\ListTemplatesOptions $options = null)
    {
        list($response) = $this->listTemplatesWithHttpInfo($account_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation listTemplatesWithHttpInfo
     *
     * Get List of Templates used in an Envelope
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTemplatesWithHttpInfo($account_id, $envelope_id, EnvelopesApi\ListTemplatesOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listTemplates');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listTemplates');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/templates";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getInclude() !== null) {
            $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateInformation',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listTemplatesForDocument
     *
     * Gets the templates associated with a document in an existing envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateInformation
     */
    public function listTemplatesForDocument($account_id, $document_id, $envelope_id, EnvelopesApi\ListTemplatesForDocumentOptions $options = null)
    {
        list($response) = $this->listTemplatesForDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation listTemplatesForDocumentWithHttpInfo
     *
     * Gets the templates associated with a document in an existing envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTemplatesForDocumentWithHttpInfo($account_id, $document_id, $envelope_id, EnvelopesApi\ListTemplatesForDocumentOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listTemplatesForDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling listTemplatesForDocument');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listTemplatesForDocument');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getInclude() !== null) {
            $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateInformation',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putAttachment
     *
     * Add an attachment to a DRAFT or IN-PROCESS envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $attachment_id 
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Attachment $attachment  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeAttachmentsResult
     */
    public function putAttachment($account_id, $attachment_id, $envelope_id, $attachment = null)
    {
        list($response) = $this->putAttachmentWithHttpInfo($account_id, $attachment_id, $envelope_id, $attachment);
        return $response;
    }

    /**
     * Operation putAttachmentWithHttpInfo
     *
     * Add an attachment to a DRAFT or IN-PROCESS envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $attachment_id 
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Attachment $attachment  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeAttachmentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function putAttachmentWithHttpInfo($account_id, $attachment_id, $envelope_id, $attachment = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling putAttachment');
        }
        // verify the required parameter 'attachment_id' is set
        if ($attachment_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $attachment_id when calling putAttachment');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling putAttachment');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($attachment_id !== null) {
            $resourcePath = str_replace(
                "{" . "attachmentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($attachment_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($attachment)) {
            $_tempBody = $attachment;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeAttachmentsResult',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putAttachments
     *
     * Add one or more attachments to a DRAFT or IN-PROCESS envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeAttachmentsRequest $envelope_attachments_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeAttachmentsResult
     */
    public function putAttachments($account_id, $envelope_id, $envelope_attachments_request = null)
    {
        list($response) = $this->putAttachmentsWithHttpInfo($account_id, $envelope_id, $envelope_attachments_request);
        return $response;
    }

    /**
     * Operation putAttachmentsWithHttpInfo
     *
     * Add one or more attachments to a DRAFT or IN-PROCESS envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeAttachmentsRequest $envelope_attachments_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeAttachmentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function putAttachmentsWithHttpInfo($account_id, $envelope_id, $envelope_attachments_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling putAttachments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling putAttachments');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_attachments_request)) {
            $_tempBody = $envelope_attachments_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeAttachmentsResult',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation rotateDocumentPage
     *
     * Rotates page image from an envelope for display.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $page_number The page number being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function rotateDocumentPage($account_id, $document_id, $envelope_id, $page_number, $page_request = null)
    {
        list($response) = $this->rotateDocumentPageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number, $page_request);
        return $response;
    }

    /**
     * Operation rotateDocumentPageWithHttpInfo
     *
     * Rotates page image from an envelope for display.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $page_number The page number being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function rotateDocumentPageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number, $page_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling rotateDocumentPage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling rotateDocumentPage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling rotateDocumentPage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling rotateDocumentPage');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = str_replace(
                "{" . "pageNumber" . "}",
                $this->apiClient->getSerializer()->toPathValue($page_number),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($page_request)) {
            $_tempBody = $page_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation update
     *
     * Send Draft Envelope/Void Envelope/Move/Purge Envelope/Modify draft
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Envelope $envelope  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeUpdateSummary
     */
    public function update($account_id, $envelope_id, $envelope = null, EnvelopesApi\UpdateOptions $options = null)
    {
        list($response) = $this->updateWithHttpInfo($account_id, $envelope_id, $envelope, $options);
        return $response;
    }

    /**
     * Operation updateWithHttpInfo
     *
     * Send Draft Envelope/Void Envelope/Move/Purge Envelope/Modify draft
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Envelope $envelope  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeUpdateSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWithHttpInfo($account_id, $envelope_id, $envelope = null, EnvelopesApi\UpdateOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling update');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling update');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getAdvancedUpdate() !== null) {
            $queryParams['advanced_update'] = $this->apiClient->getSerializer()->toQueryValue($options->getAdvancedUpdate());
        }
        // query params
        if ($options->getResendEnvelope() !== null) {
            $queryParams['resend_envelope'] = $this->apiClient->getSerializer()->toQueryValue($options->getResendEnvelope());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope)) {
            $_tempBody = $envelope;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeUpdateSummary',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeUpdateSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeUpdateSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateChunkedUpload
     *
     * Integrity-Check and Commit a ChunkedUpload, readying it for use elsewhere.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $chunked_upload_id 
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ChunkedUploadResponse
     */
    public function updateChunkedUpload($account_id, $chunked_upload_id, EnvelopesApi\UpdateChunkedUploadOptions $options = null)
    {
        list($response) = $this->updateChunkedUploadWithHttpInfo($account_id, $chunked_upload_id, $options);
        return $response;
    }

    /**
     * Operation updateChunkedUploadWithHttpInfo
     *
     * Integrity-Check and Commit a ChunkedUpload, readying it for use elsewhere.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $chunked_upload_id 
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ChunkedUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateChunkedUploadWithHttpInfo($account_id, $chunked_upload_id, EnvelopesApi\UpdateChunkedUploadOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateChunkedUpload');
        }
        // verify the required parameter 'chunked_upload_id' is set
        if ($chunked_upload_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chunked_upload_id when calling updateChunkedUpload');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getAction() !== null) {
            $queryParams['action'] = $this->apiClient->getSerializer()->toQueryValue($options->getAction());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($chunked_upload_id !== null) {
            $resourcePath = str_replace(
                "{" . "chunkedUploadId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chunked_upload_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ChunkedUploadResponse',
                '/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ChunkedUploadResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ChunkedUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateChunkedUploadPart
     *
     * Add a chunk, a chunk 'part', to an existing ChunkedUpload.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $chunked_upload_id 
    * @param string $chunked_upload_part_seq 
     * @param \DocuSign\eSign\Model\ChunkedUploadRequest $chunked_upload_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ChunkedUploadResponse
     */
    public function updateChunkedUploadPart($account_id, $chunked_upload_id, $chunked_upload_part_seq, $chunked_upload_request = null)
    {
        list($response) = $this->updateChunkedUploadPartWithHttpInfo($account_id, $chunked_upload_id, $chunked_upload_part_seq, $chunked_upload_request);
        return $response;
    }

    /**
     * Operation updateChunkedUploadPartWithHttpInfo
     *
     * Add a chunk, a chunk 'part', to an existing ChunkedUpload.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $chunked_upload_id 
    * @param string $chunked_upload_part_seq 
     * @param \DocuSign\eSign\Model\ChunkedUploadRequest $chunked_upload_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ChunkedUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateChunkedUploadPartWithHttpInfo($account_id, $chunked_upload_id, $chunked_upload_part_seq, $chunked_upload_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateChunkedUploadPart');
        }
        // verify the required parameter 'chunked_upload_id' is set
        if ($chunked_upload_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chunked_upload_id when calling updateChunkedUploadPart');
        }
        // verify the required parameter 'chunked_upload_part_seq' is set
        if ($chunked_upload_part_seq === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chunked_upload_part_seq when calling updateChunkedUploadPart');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/{chunkedUploadPartSeq}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($chunked_upload_id !== null) {
            $resourcePath = str_replace(
                "{" . "chunkedUploadId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chunked_upload_id),
                $resourcePath
            );
        }
        // path params
        if ($chunked_upload_part_seq !== null) {
            $resourcePath = str_replace(
                "{" . "chunkedUploadPartSeq" . "}",
                $this->apiClient->getSerializer()->toPathValue($chunked_upload_part_seq),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($chunked_upload_request)) {
            $_tempBody = $chunked_upload_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ChunkedUploadResponse',
                '/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/{chunkedUploadPartSeq}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ChunkedUploadResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ChunkedUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateCustomFields
     *
     * Updates envelope custom fields in an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function updateCustomFields($account_id, $envelope_id, $custom_fields = null)
    {
        list($response) = $this->updateCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields);
        return $response;
    }

    /**
     * Operation updateCustomFieldsWithHttpInfo
     *
     * Updates envelope custom fields in an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateCustomFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($custom_fields)) {
            $_tempBody = $custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocument
     *
     * Adds a document to an existing draft envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function updateDocument($account_id, $document_id, $envelope_id, EnvelopesApi\UpdateDocumentOptions $options = null)
    {
        list($response) = $this->updateDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation updateDocumentWithHttpInfo
     *
     * Adds a document to an existing draft envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentWithHttpInfo($account_id, $document_id, $envelope_id, EnvelopesApi\UpdateDocumentOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling updateDocument');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateDocument');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getApplyDocumentFields() !== null) {
            $queryParams['apply_document_fields'] = $this->apiClient->getSerializer()->toQueryValue($options->getApplyDocumentFields());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocumentFields
     *
     * Updates existing custom document fields in an existing envelope document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function updateDocumentFields($account_id, $document_id, $envelope_id, $document_fields_information = null)
    {
        list($response) = $this->updateDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation updateDocumentFieldsWithHttpInfo
     *
     * Updates existing custom document fields in an existing envelope document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling updateDocumentFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocuments
     *
     * Adds one or more documents to an existing envelope document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeDocumentsResult
     */
    public function updateDocuments($account_id, $envelope_id, $envelope_definition = null, EnvelopesApi\UpdateDocumentsOptions $options = null)
    {
        list($response) = $this->updateDocumentsWithHttpInfo($account_id, $envelope_id, $envelope_definition, $options);
        return $response;
    }

    /**
     * Operation updateDocumentsWithHttpInfo
     *
     * Adds one or more documents to an existing envelope document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentsWithHttpInfo($account_id, $envelope_id, $envelope_definition = null, EnvelopesApi\UpdateDocumentsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocuments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateDocuments');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getApplyDocumentFields() !== null) {
            $queryParams['apply_document_fields'] = $this->apiClient->getSerializer()->toQueryValue($options->getApplyDocumentFields());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeDocumentsResult',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateEmailSettings
     *
     * Updates the email setting overrides for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EmailSettings $email_settings  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EmailSettings
     */
    public function updateEmailSettings($account_id, $envelope_id, $email_settings = null)
    {
        list($response) = $this->updateEmailSettingsWithHttpInfo($account_id, $envelope_id, $email_settings);
        return $response;
    }

    /**
     * Operation updateEmailSettingsWithHttpInfo
     *
     * Updates the email setting overrides for an envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EmailSettings $email_settings  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EmailSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmailSettingsWithHttpInfo($account_id, $envelope_id, $email_settings = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateEmailSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateEmailSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($email_settings)) {
            $_tempBody = $email_settings;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EmailSettings',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EmailSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EmailSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateLock
     *
     * Updates an envelope lock.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function updateLock($account_id, $envelope_id, $lock_request = null)
    {
        list($response) = $this->updateLockWithHttpInfo($account_id, $envelope_id, $lock_request);
        return $response;
    }

    /**
     * Operation updateLockWithHttpInfo
     *
     * Updates an envelope lock.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLockWithHttpInfo($account_id, $envelope_id, $lock_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateLock');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateLock');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($lock_request)) {
            $_tempBody = $lock_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateNotificationSettings
     *
     * Sets envelope notification (Reminders/Expirations) structure for an existing envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeNotificationRequest $envelope_notification_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Notification
     */
    public function updateNotificationSettings($account_id, $envelope_id, $envelope_notification_request = null)
    {
        list($response) = $this->updateNotificationSettingsWithHttpInfo($account_id, $envelope_id, $envelope_notification_request);
        return $response;
    }

    /**
     * Operation updateNotificationSettingsWithHttpInfo
     *
     * Sets envelope notification (Reminders/Expirations) structure for an existing envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeNotificationRequest $envelope_notification_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Notification, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateNotificationSettingsWithHttpInfo($account_id, $envelope_id, $envelope_notification_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateNotificationSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateNotificationSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/notification";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_notification_request)) {
            $_tempBody = $envelope_notification_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Notification',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/notification'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Notification', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Notification', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipientDocumentVisibility
     *
     * Updates document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\DocumentVisibilityList $document_visibility_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentVisibilityList
     */
    public function updateRecipientDocumentVisibility($account_id, $envelope_id, $recipient_id, $document_visibility_list = null)
    {
        list($response) = $this->updateRecipientDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $recipient_id, $document_visibility_list);
        return $response;
    }

    /**
     * Operation updateRecipientDocumentVisibilityWithHttpInfo
     *
     * Updates document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\DocumentVisibilityList $document_visibility_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $recipient_id, $document_visibility_list = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipientDocumentVisibility');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateRecipientDocumentVisibility');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateRecipientDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($document_visibility_list)) {
            $_tempBody = $document_visibility_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentVisibilityList',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipientInitialsImage
     *
     * Sets the initials image for an accountless signer.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function updateRecipientInitialsImage($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->updateRecipientInitialsImageWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation updateRecipientInitialsImageWithHttpInfo
     *
     * Sets the initials image for an accountless signer.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientInitialsImageWithHttpInfo($account_id, $envelope_id, $recipient_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipientInitialsImage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateRecipientInitialsImage');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateRecipientInitialsImage');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipientSignatureImage
     *
     * Sets the signature image for an accountless signer.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function updateRecipientSignatureImage($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->updateRecipientSignatureImageWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation updateRecipientSignatureImageWithHttpInfo
     *
     * Sets the signature image for an accountless signer.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientSignatureImageWithHttpInfo($account_id, $envelope_id, $recipient_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipientSignatureImage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateRecipientSignatureImage');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateRecipientSignatureImage');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipients
     *
     * Updates recipients in a draft envelope or corrects recipient information for an in process envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\RecipientsUpdateSummary
     */
    public function updateRecipients($account_id, $envelope_id, $recipients = null, EnvelopesApi\UpdateRecipientsOptions $options = null)
    {
        list($response) = $this->updateRecipientsWithHttpInfo($account_id, $envelope_id, $recipients, $options);
        return $response;
    }

    /**
     * Operation updateRecipientsWithHttpInfo
     *
     * Updates recipients in a draft envelope or corrects recipient information for an in process envelope.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\RecipientsUpdateSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientsWithHttpInfo($account_id, $envelope_id, $recipients = null, EnvelopesApi\UpdateRecipientsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipients');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateRecipients');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getResendEnvelope() !== null) {
            $queryParams['resend_envelope'] = $this->apiClient->getSerializer()->toQueryValue($options->getResendEnvelope());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($recipients)) {
            $_tempBody = $recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\RecipientsUpdateSummary',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\RecipientsUpdateSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\RecipientsUpdateSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipientsDocumentVisibility
     *
     * Updates document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentVisibilityList $document_visibility_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentVisibilityList
     */
    public function updateRecipientsDocumentVisibility($account_id, $envelope_id, $document_visibility_list = null)
    {
        list($response) = $this->updateRecipientsDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $document_visibility_list);
        return $response;
    }

    /**
     * Operation updateRecipientsDocumentVisibilityWithHttpInfo
     *
     * Updates document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentVisibilityList $document_visibility_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientsDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $document_visibility_list = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipientsDocumentVisibility');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateRecipientsDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/document_visibility";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($document_visibility_list)) {
            $_tempBody = $document_visibility_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentVisibilityList',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTabs
     *
     * Updates the tabs for a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function updateTabs($account_id, $envelope_id, $recipient_id, $tabs = null)
    {
        list($response) = $this->updateTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs);
        return $response;
    }

    /**
     * Operation updateTabsWithHttpInfo
     *
     * Updates the tabs for a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $envelope_id The envelopeId Guid of the envelope being accessed.
    * @param string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateTabs');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = str_replace(
                "{" . "envelopeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($envelope_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($tabs)) {
            $_tempBody = $tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTemplateRecipientDocumentVisibility
     *
     * Updates document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateDocumentVisibilityList $template_document_visibility_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateDocumentVisibilityList
     */
    public function updateTemplateRecipientDocumentVisibility($account_id, $recipient_id, $template_id, $template_document_visibility_list = null)
    {
        list($response) = $this->updateTemplateRecipientDocumentVisibilityWithHttpInfo($account_id, $recipient_id, $template_id, $template_document_visibility_list);
        return $response;
    }

    /**
     * Operation updateTemplateRecipientDocumentVisibilityWithHttpInfo
     *
     * Updates document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateDocumentVisibilityList $template_document_visibility_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateDocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTemplateRecipientDocumentVisibilityWithHttpInfo($account_id, $recipient_id, $template_id, $template_document_visibility_list = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTemplateRecipientDocumentVisibility');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateTemplateRecipientDocumentVisibility');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateTemplateRecipientDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_document_visibility_list)) {
            $_tempBody = $template_document_visibility_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateDocumentVisibilityList',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateDocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateDocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTemplateRecipientsDocumentVisibility
     *
     * Updates document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateDocumentVisibilityList $template_document_visibility_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateDocumentVisibilityList
     */
    public function updateTemplateRecipientsDocumentVisibility($account_id, $template_id, $template_document_visibility_list = null)
    {
        list($response) = $this->updateTemplateRecipientsDocumentVisibilityWithHttpInfo($account_id, $template_id, $template_document_visibility_list);
        return $response;
    }

    /**
     * Operation updateTemplateRecipientsDocumentVisibilityWithHttpInfo
     *
     * Updates document visibility for the recipients
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateDocumentVisibilityList $template_document_visibility_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateDocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTemplateRecipientsDocumentVisibilityWithHttpInfo($account_id, $template_id, $template_document_visibility_list = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTemplateRecipientsDocumentVisibility');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateTemplateRecipientsDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients/document_visibility";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_document_visibility_list)) {
            $_tempBody = $template_document_visibility_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateDocumentVisibilityList',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateDocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateDocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
