<?php
/**
 * SigningGroupsApi
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\SigningGroupsApi;

class ListOptions
{
    /**
      * $group_type 
      * @var string
      */
    protected $group_type;

    /**
     * Gets group_type
     * @return string
     */
    public function getGroupType()
    {
        return $this->group_type;
    }
  
    /**
     * Sets group_type
     * @param string $group_type 
     * @return $this
     */
    public function setGroupType($group_type)
    {
        $this->group_type = $group_type;
        return $this;
    }
    /**
      * $include_users When set to **true**, the response includes the signing group members.
      * @var string
      */
    protected $include_users;

    /**
     * Gets include_users
     * @return string
     */
    public function getIncludeUsers()
    {
        return $this->include_users;
    }
  
    /**
     * Sets include_users
     * @param string $include_users When set to **true**, the response includes the signing group members.
     * @return $this
     */
    public function setIncludeUsers($include_users)
    {
        $this->include_users = $include_users;
        return $this;
    }
}


namespace DocuSign\eSign\Api;

use \DocuSign\eSign\ApiClient;
use \DocuSign\eSign\ApiException;
use \DocuSign\eSign\Configuration;
use \DocuSign\eSign\ObjectSerializer;

/**
 * SigningGroupsApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SigningGroupsApi
{
    /**
     * API Client
     *
     * @var \DocuSign\eSign\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \DocuSign\eSign\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\DocuSign\eSign\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \DocuSign\eSign\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \DocuSign\eSign\ApiClient $apiClient set the API client
     *
     * @return SigningGroupsApi
     */
    public function setApiClient(\DocuSign\eSign\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation callList
     *
     * Gets a list of the Signing Groups in an account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\SigningGroupInformation
     */
    public function callList($account_id, SigningGroupsApi\ListOptions $options = null)
    {
        list($response) = $this->callListWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation callListWithHttpInfo
     *
     * Gets a list of the Signing Groups in an account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\SigningGroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function callListWithHttpInfo($account_id, SigningGroupsApi\ListOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling callList');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/signing_groups";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getGroupType() !== null) {
            $queryParams['group_type'] = $this->apiClient->getSerializer()->toQueryValue($options->getGroupType());
        }
        // query params
        if ($options->getIncludeUsers() !== null) {
            $queryParams['include_users'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeUsers());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\SigningGroupInformation',
                '/v2/accounts/{accountId}/signing_groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\SigningGroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\SigningGroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createList
     *
     * Creates a signing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\SigningGroupInformation $signing_group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\SigningGroupInformation
     */
    public function createList($account_id, $signing_group_information = null)
    {
        list($response) = $this->createListWithHttpInfo($account_id, $signing_group_information);
        return $response;
    }

    /**
     * Operation createListWithHttpInfo
     *
     * Creates a signing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\SigningGroupInformation $signing_group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\SigningGroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createListWithHttpInfo($account_id, $signing_group_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createList');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/signing_groups";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($signing_group_information)) {
            $_tempBody = $signing_group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\SigningGroupInformation',
                '/v2/accounts/{accountId}/signing_groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\SigningGroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\SigningGroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteList
     *
     * Deletes one or more signing groups.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\SigningGroupInformation $signing_group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\SigningGroupInformation
     */
    public function deleteList($account_id, $signing_group_information = null)
    {
        list($response) = $this->deleteListWithHttpInfo($account_id, $signing_group_information);
        return $response;
    }

    /**
     * Operation deleteListWithHttpInfo
     *
     * Deletes one or more signing groups.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\SigningGroupInformation $signing_group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\SigningGroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteListWithHttpInfo($account_id, $signing_group_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteList');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/signing_groups";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($signing_group_information)) {
            $_tempBody = $signing_group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\SigningGroupInformation',
                '/v2/accounts/{accountId}/signing_groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\SigningGroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\SigningGroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteUsers
     *
     * Deletes  one or more members from a signing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $signing_group_id 
     * @param \DocuSign\eSign\Model\SigningGroupUsers $signing_group_users  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\SigningGroupUsers
     */
    public function deleteUsers($account_id, $signing_group_id, $signing_group_users = null)
    {
        list($response) = $this->deleteUsersWithHttpInfo($account_id, $signing_group_id, $signing_group_users);
        return $response;
    }

    /**
     * Operation deleteUsersWithHttpInfo
     *
     * Deletes  one or more members from a signing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $signing_group_id 
     * @param \DocuSign\eSign\Model\SigningGroupUsers $signing_group_users  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\SigningGroupUsers, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteUsersWithHttpInfo($account_id, $signing_group_id, $signing_group_users = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteUsers');
        }
        // verify the required parameter 'signing_group_id' is set
        if ($signing_group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signing_group_id when calling deleteUsers');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/signing_groups/{signingGroupId}/users";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($signing_group_id !== null) {
            $resourcePath = str_replace(
                "{" . "signingGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($signing_group_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($signing_group_users)) {
            $_tempBody = $signing_group_users;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\SigningGroupUsers',
                '/v2/accounts/{accountId}/signing_groups/{signingGroupId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\SigningGroupUsers', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\SigningGroupUsers', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation get
     *
     * Gets information about a signing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $signing_group_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\SigningGroup
     */
    public function get($account_id, $signing_group_id)
    {
        list($response) = $this->getWithHttpInfo($account_id, $signing_group_id);
        return $response;
    }

    /**
     * Operation getWithHttpInfo
     *
     * Gets information about a signing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $signing_group_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\SigningGroup, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWithHttpInfo($account_id, $signing_group_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling get');
        }
        // verify the required parameter 'signing_group_id' is set
        if ($signing_group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signing_group_id when calling get');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/signing_groups/{signingGroupId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($signing_group_id !== null) {
            $resourcePath = str_replace(
                "{" . "signingGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($signing_group_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\SigningGroup',
                '/v2/accounts/{accountId}/signing_groups/{signingGroupId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\SigningGroup', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\SigningGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listUsers
     *
     * Gets a list of members in a Signing Group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $signing_group_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\SigningGroupUsers
     */
    public function listUsers($account_id, $signing_group_id)
    {
        list($response) = $this->listUsersWithHttpInfo($account_id, $signing_group_id);
        return $response;
    }

    /**
     * Operation listUsersWithHttpInfo
     *
     * Gets a list of members in a Signing Group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $signing_group_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\SigningGroupUsers, HTTP status code, HTTP response headers (array of strings)
     */
    public function listUsersWithHttpInfo($account_id, $signing_group_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listUsers');
        }
        // verify the required parameter 'signing_group_id' is set
        if ($signing_group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signing_group_id when calling listUsers');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/signing_groups/{signingGroupId}/users";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($signing_group_id !== null) {
            $resourcePath = str_replace(
                "{" . "signingGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($signing_group_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\SigningGroupUsers',
                '/v2/accounts/{accountId}/signing_groups/{signingGroupId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\SigningGroupUsers', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\SigningGroupUsers', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation update
     *
     * Updates a signing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $signing_group_id 
     * @param \DocuSign\eSign\Model\SigningGroup $signing_group  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\SigningGroup
     */
    public function update($account_id, $signing_group_id, $signing_group = null)
    {
        list($response) = $this->updateWithHttpInfo($account_id, $signing_group_id, $signing_group);
        return $response;
    }

    /**
     * Operation updateWithHttpInfo
     *
     * Updates a signing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $signing_group_id 
     * @param \DocuSign\eSign\Model\SigningGroup $signing_group  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\SigningGroup, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWithHttpInfo($account_id, $signing_group_id, $signing_group = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling update');
        }
        // verify the required parameter 'signing_group_id' is set
        if ($signing_group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signing_group_id when calling update');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/signing_groups/{signingGroupId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($signing_group_id !== null) {
            $resourcePath = str_replace(
                "{" . "signingGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($signing_group_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($signing_group)) {
            $_tempBody = $signing_group;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\SigningGroup',
                '/v2/accounts/{accountId}/signing_groups/{signingGroupId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\SigningGroup', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\SigningGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateList
     *
     * Updates signing group names.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\SigningGroupInformation $signing_group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\SigningGroupInformation
     */
    public function updateList($account_id, $signing_group_information = null)
    {
        list($response) = $this->updateListWithHttpInfo($account_id, $signing_group_information);
        return $response;
    }

    /**
     * Operation updateListWithHttpInfo
     *
     * Updates signing group names.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\SigningGroupInformation $signing_group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\SigningGroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateListWithHttpInfo($account_id, $signing_group_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateList');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/signing_groups";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($signing_group_information)) {
            $_tempBody = $signing_group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\SigningGroupInformation',
                '/v2/accounts/{accountId}/signing_groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\SigningGroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\SigningGroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateUsers
     *
     * Adds members to a signing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $signing_group_id 
     * @param \DocuSign\eSign\Model\SigningGroupUsers $signing_group_users  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\SigningGroupUsers
     */
    public function updateUsers($account_id, $signing_group_id, $signing_group_users = null)
    {
        list($response) = $this->updateUsersWithHttpInfo($account_id, $signing_group_id, $signing_group_users);
        return $response;
    }

    /**
     * Operation updateUsersWithHttpInfo
     *
     * Adds members to a signing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $signing_group_id 
     * @param \DocuSign\eSign\Model\SigningGroupUsers $signing_group_users  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\SigningGroupUsers, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateUsersWithHttpInfo($account_id, $signing_group_id, $signing_group_users = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateUsers');
        }
        // verify the required parameter 'signing_group_id' is set
        if ($signing_group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signing_group_id when calling updateUsers');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/signing_groups/{signingGroupId}/users";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($signing_group_id !== null) {
            $resourcePath = str_replace(
                "{" . "signingGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($signing_group_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($signing_group_users)) {
            $_tempBody = $signing_group_users;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\SigningGroupUsers',
                '/v2/accounts/{accountId}/signing_groups/{signingGroupId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\SigningGroupUsers', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\SigningGroupUsers', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
