<?php
/**
 * EnvelopeTemplateResult
 *
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;

/**
 * EnvelopeTemplateResult Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EnvelopeTemplateResult implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'envelopeTemplateResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'allow_markup' => 'string',
        'allow_reassign' => 'string',
        'asynchronous' => 'string',
        'attachments_uri' => 'string',
        'authoritative_copy' => 'string',
        'auto_navigation' => 'string',
        'brand_id' => 'string',
        'brand_lock' => 'string',
        'certificate_uri' => 'string',
        'completed_date_time' => 'string',
        'created_date_time' => 'string',
        'custom_fields' => '\DocuSign\eSign\Model\CustomFields',
        'custom_fields_uri' => 'string',
        'declined_date_time' => 'string',
        'deleted_date_time' => 'string',
        'delivered_date_time' => 'string',
        'description' => 'string',
        'documents' => '\DocuSign\eSign\Model\Document[]',
        'documents_combined_uri' => 'string',
        'documents_uri' => 'string',
        'email_blurb' => 'string',
        'email_settings' => '\DocuSign\eSign\Model\EmailSettings',
        'email_subject' => 'string',
        'enable_wet_sign' => 'string',
        'enforce_signer_visibility' => 'string',
        'envelope_id' => 'string',
        'envelope_id_stamping' => 'string',
        'envelope_uri' => 'string',
        'folder_id' => 'string',
        'folder_name' => 'string',
        'folder_uri' => 'string',
        'initial_sent_date_time' => 'string',
        'is21_cfr_part11' => 'string',
        'is_signature_provider_envelope' => 'string',
        'last_modified' => 'string',
        'last_modified_date_time' => 'string',
        'lock_information' => '\DocuSign\eSign\Model\LockInformation',
        'message_lock' => 'string',
        'name' => 'string',
        'notification' => '\DocuSign\eSign\Model\Notification',
        'notification_uri' => 'string',
        'owner' => '\DocuSign\eSign\Model\UserInfo',
        'page_count' => 'int',
        'parent_folder_uri' => 'string',
        'password' => 'string',
        'purge_state' => 'string',
        'recipients' => '\DocuSign\eSign\Model\Recipients',
        'recipients_lock' => 'string',
        'recipients_uri' => 'string',
        'sent_date_time' => 'string',
        'shared' => 'string',
        'signing_location' => 'string',
        'status' => 'string',
        'status_changed_date_time' => 'string',
        'template_id' => 'string',
        'templates_uri' => 'string',
        'transaction_id' => 'string',
        'uri' => 'string',
        'use_disclosure' => 'string',
        'voided_date_time' => 'string',
        'voided_reason' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'allow_markup' => 'allowMarkup',
        'allow_reassign' => 'allowReassign',
        'asynchronous' => 'asynchronous',
        'attachments_uri' => 'attachmentsUri',
        'authoritative_copy' => 'authoritativeCopy',
        'auto_navigation' => 'autoNavigation',
        'brand_id' => 'brandId',
        'brand_lock' => 'brandLock',
        'certificate_uri' => 'certificateUri',
        'completed_date_time' => 'completedDateTime',
        'created_date_time' => 'createdDateTime',
        'custom_fields' => 'customFields',
        'custom_fields_uri' => 'customFieldsUri',
        'declined_date_time' => 'declinedDateTime',
        'deleted_date_time' => 'deletedDateTime',
        'delivered_date_time' => 'deliveredDateTime',
        'description' => 'description',
        'documents' => 'documents',
        'documents_combined_uri' => 'documentsCombinedUri',
        'documents_uri' => 'documentsUri',
        'email_blurb' => 'emailBlurb',
        'email_settings' => 'emailSettings',
        'email_subject' => 'emailSubject',
        'enable_wet_sign' => 'enableWetSign',
        'enforce_signer_visibility' => 'enforceSignerVisibility',
        'envelope_id' => 'envelopeId',
        'envelope_id_stamping' => 'envelopeIdStamping',
        'envelope_uri' => 'envelopeUri',
        'folder_id' => 'folderId',
        'folder_name' => 'folderName',
        'folder_uri' => 'folderUri',
        'initial_sent_date_time' => 'initialSentDateTime',
        'is21_cfr_part11' => 'is21CFRPart11',
        'is_signature_provider_envelope' => 'isSignatureProviderEnvelope',
        'last_modified' => 'lastModified',
        'last_modified_date_time' => 'lastModifiedDateTime',
        'lock_information' => 'lockInformation',
        'message_lock' => 'messageLock',
        'name' => 'name',
        'notification' => 'notification',
        'notification_uri' => 'notificationUri',
        'owner' => 'owner',
        'page_count' => 'pageCount',
        'parent_folder_uri' => 'parentFolderUri',
        'password' => 'password',
        'purge_state' => 'purgeState',
        'recipients' => 'recipients',
        'recipients_lock' => 'recipientsLock',
        'recipients_uri' => 'recipientsUri',
        'sent_date_time' => 'sentDateTime',
        'shared' => 'shared',
        'signing_location' => 'signingLocation',
        'status' => 'status',
        'status_changed_date_time' => 'statusChangedDateTime',
        'template_id' => 'templateId',
        'templates_uri' => 'templatesUri',
        'transaction_id' => 'transactionId',
        'uri' => 'uri',
        'use_disclosure' => 'useDisclosure',
        'voided_date_time' => 'voidedDateTime',
        'voided_reason' => 'voidedReason'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'allow_markup' => 'setAllowMarkup',
        'allow_reassign' => 'setAllowReassign',
        'asynchronous' => 'setAsynchronous',
        'attachments_uri' => 'setAttachmentsUri',
        'authoritative_copy' => 'setAuthoritativeCopy',
        'auto_navigation' => 'setAutoNavigation',
        'brand_id' => 'setBrandId',
        'brand_lock' => 'setBrandLock',
        'certificate_uri' => 'setCertificateUri',
        'completed_date_time' => 'setCompletedDateTime',
        'created_date_time' => 'setCreatedDateTime',
        'custom_fields' => 'setCustomFields',
        'custom_fields_uri' => 'setCustomFieldsUri',
        'declined_date_time' => 'setDeclinedDateTime',
        'deleted_date_time' => 'setDeletedDateTime',
        'delivered_date_time' => 'setDeliveredDateTime',
        'description' => 'setDescription',
        'documents' => 'setDocuments',
        'documents_combined_uri' => 'setDocumentsCombinedUri',
        'documents_uri' => 'setDocumentsUri',
        'email_blurb' => 'setEmailBlurb',
        'email_settings' => 'setEmailSettings',
        'email_subject' => 'setEmailSubject',
        'enable_wet_sign' => 'setEnableWetSign',
        'enforce_signer_visibility' => 'setEnforceSignerVisibility',
        'envelope_id' => 'setEnvelopeId',
        'envelope_id_stamping' => 'setEnvelopeIdStamping',
        'envelope_uri' => 'setEnvelopeUri',
        'folder_id' => 'setFolderId',
        'folder_name' => 'setFolderName',
        'folder_uri' => 'setFolderUri',
        'initial_sent_date_time' => 'setInitialSentDateTime',
        'is21_cfr_part11' => 'setIs21CfrPart11',
        'is_signature_provider_envelope' => 'setIsSignatureProviderEnvelope',
        'last_modified' => 'setLastModified',
        'last_modified_date_time' => 'setLastModifiedDateTime',
        'lock_information' => 'setLockInformation',
        'message_lock' => 'setMessageLock',
        'name' => 'setName',
        'notification' => 'setNotification',
        'notification_uri' => 'setNotificationUri',
        'owner' => 'setOwner',
        'page_count' => 'setPageCount',
        'parent_folder_uri' => 'setParentFolderUri',
        'password' => 'setPassword',
        'purge_state' => 'setPurgeState',
        'recipients' => 'setRecipients',
        'recipients_lock' => 'setRecipientsLock',
        'recipients_uri' => 'setRecipientsUri',
        'sent_date_time' => 'setSentDateTime',
        'shared' => 'setShared',
        'signing_location' => 'setSigningLocation',
        'status' => 'setStatus',
        'status_changed_date_time' => 'setStatusChangedDateTime',
        'template_id' => 'setTemplateId',
        'templates_uri' => 'setTemplatesUri',
        'transaction_id' => 'setTransactionId',
        'uri' => 'setUri',
        'use_disclosure' => 'setUseDisclosure',
        'voided_date_time' => 'setVoidedDateTime',
        'voided_reason' => 'setVoidedReason'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'allow_markup' => 'getAllowMarkup',
        'allow_reassign' => 'getAllowReassign',
        'asynchronous' => 'getAsynchronous',
        'attachments_uri' => 'getAttachmentsUri',
        'authoritative_copy' => 'getAuthoritativeCopy',
        'auto_navigation' => 'getAutoNavigation',
        'brand_id' => 'getBrandId',
        'brand_lock' => 'getBrandLock',
        'certificate_uri' => 'getCertificateUri',
        'completed_date_time' => 'getCompletedDateTime',
        'created_date_time' => 'getCreatedDateTime',
        'custom_fields' => 'getCustomFields',
        'custom_fields_uri' => 'getCustomFieldsUri',
        'declined_date_time' => 'getDeclinedDateTime',
        'deleted_date_time' => 'getDeletedDateTime',
        'delivered_date_time' => 'getDeliveredDateTime',
        'description' => 'getDescription',
        'documents' => 'getDocuments',
        'documents_combined_uri' => 'getDocumentsCombinedUri',
        'documents_uri' => 'getDocumentsUri',
        'email_blurb' => 'getEmailBlurb',
        'email_settings' => 'getEmailSettings',
        'email_subject' => 'getEmailSubject',
        'enable_wet_sign' => 'getEnableWetSign',
        'enforce_signer_visibility' => 'getEnforceSignerVisibility',
        'envelope_id' => 'getEnvelopeId',
        'envelope_id_stamping' => 'getEnvelopeIdStamping',
        'envelope_uri' => 'getEnvelopeUri',
        'folder_id' => 'getFolderId',
        'folder_name' => 'getFolderName',
        'folder_uri' => 'getFolderUri',
        'initial_sent_date_time' => 'getInitialSentDateTime',
        'is21_cfr_part11' => 'getIs21CfrPart11',
        'is_signature_provider_envelope' => 'getIsSignatureProviderEnvelope',
        'last_modified' => 'getLastModified',
        'last_modified_date_time' => 'getLastModifiedDateTime',
        'lock_information' => 'getLockInformation',
        'message_lock' => 'getMessageLock',
        'name' => 'getName',
        'notification' => 'getNotification',
        'notification_uri' => 'getNotificationUri',
        'owner' => 'getOwner',
        'page_count' => 'getPageCount',
        'parent_folder_uri' => 'getParentFolderUri',
        'password' => 'getPassword',
        'purge_state' => 'getPurgeState',
        'recipients' => 'getRecipients',
        'recipients_lock' => 'getRecipientsLock',
        'recipients_uri' => 'getRecipientsUri',
        'sent_date_time' => 'getSentDateTime',
        'shared' => 'getShared',
        'signing_location' => 'getSigningLocation',
        'status' => 'getStatus',
        'status_changed_date_time' => 'getStatusChangedDateTime',
        'template_id' => 'getTemplateId',
        'templates_uri' => 'getTemplatesUri',
        'transaction_id' => 'getTransactionId',
        'uri' => 'getUri',
        'use_disclosure' => 'getUseDisclosure',
        'voided_date_time' => 'getVoidedDateTime',
        'voided_reason' => 'getVoidedReason'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['allow_markup'] = isset($data['allow_markup']) ? $data['allow_markup'] : null;
        $this->container['allow_reassign'] = isset($data['allow_reassign']) ? $data['allow_reassign'] : null;
        $this->container['asynchronous'] = isset($data['asynchronous']) ? $data['asynchronous'] : null;
        $this->container['attachments_uri'] = isset($data['attachments_uri']) ? $data['attachments_uri'] : null;
        $this->container['authoritative_copy'] = isset($data['authoritative_copy']) ? $data['authoritative_copy'] : null;
        $this->container['auto_navigation'] = isset($data['auto_navigation']) ? $data['auto_navigation'] : null;
        $this->container['brand_id'] = isset($data['brand_id']) ? $data['brand_id'] : null;
        $this->container['brand_lock'] = isset($data['brand_lock']) ? $data['brand_lock'] : null;
        $this->container['certificate_uri'] = isset($data['certificate_uri']) ? $data['certificate_uri'] : null;
        $this->container['completed_date_time'] = isset($data['completed_date_time']) ? $data['completed_date_time'] : null;
        $this->container['created_date_time'] = isset($data['created_date_time']) ? $data['created_date_time'] : null;
        $this->container['custom_fields'] = isset($data['custom_fields']) ? $data['custom_fields'] : null;
        $this->container['custom_fields_uri'] = isset($data['custom_fields_uri']) ? $data['custom_fields_uri'] : null;
        $this->container['declined_date_time'] = isset($data['declined_date_time']) ? $data['declined_date_time'] : null;
        $this->container['deleted_date_time'] = isset($data['deleted_date_time']) ? $data['deleted_date_time'] : null;
        $this->container['delivered_date_time'] = isset($data['delivered_date_time']) ? $data['delivered_date_time'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['documents'] = isset($data['documents']) ? $data['documents'] : null;
        $this->container['documents_combined_uri'] = isset($data['documents_combined_uri']) ? $data['documents_combined_uri'] : null;
        $this->container['documents_uri'] = isset($data['documents_uri']) ? $data['documents_uri'] : null;
        $this->container['email_blurb'] = isset($data['email_blurb']) ? $data['email_blurb'] : null;
        $this->container['email_settings'] = isset($data['email_settings']) ? $data['email_settings'] : null;
        $this->container['email_subject'] = isset($data['email_subject']) ? $data['email_subject'] : null;
        $this->container['enable_wet_sign'] = isset($data['enable_wet_sign']) ? $data['enable_wet_sign'] : null;
        $this->container['enforce_signer_visibility'] = isset($data['enforce_signer_visibility']) ? $data['enforce_signer_visibility'] : null;
        $this->container['envelope_id'] = isset($data['envelope_id']) ? $data['envelope_id'] : null;
        $this->container['envelope_id_stamping'] = isset($data['envelope_id_stamping']) ? $data['envelope_id_stamping'] : null;
        $this->container['envelope_uri'] = isset($data['envelope_uri']) ? $data['envelope_uri'] : null;
        $this->container['folder_id'] = isset($data['folder_id']) ? $data['folder_id'] : null;
        $this->container['folder_name'] = isset($data['folder_name']) ? $data['folder_name'] : null;
        $this->container['folder_uri'] = isset($data['folder_uri']) ? $data['folder_uri'] : null;
        $this->container['initial_sent_date_time'] = isset($data['initial_sent_date_time']) ? $data['initial_sent_date_time'] : null;
        $this->container['is21_cfr_part11'] = isset($data['is21_cfr_part11']) ? $data['is21_cfr_part11'] : null;
        $this->container['is_signature_provider_envelope'] = isset($data['is_signature_provider_envelope']) ? $data['is_signature_provider_envelope'] : null;
        $this->container['last_modified'] = isset($data['last_modified']) ? $data['last_modified'] : null;
        $this->container['last_modified_date_time'] = isset($data['last_modified_date_time']) ? $data['last_modified_date_time'] : null;
        $this->container['lock_information'] = isset($data['lock_information']) ? $data['lock_information'] : null;
        $this->container['message_lock'] = isset($data['message_lock']) ? $data['message_lock'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['notification'] = isset($data['notification']) ? $data['notification'] : null;
        $this->container['notification_uri'] = isset($data['notification_uri']) ? $data['notification_uri'] : null;
        $this->container['owner'] = isset($data['owner']) ? $data['owner'] : null;
        $this->container['page_count'] = isset($data['page_count']) ? $data['page_count'] : null;
        $this->container['parent_folder_uri'] = isset($data['parent_folder_uri']) ? $data['parent_folder_uri'] : null;
        $this->container['password'] = isset($data['password']) ? $data['password'] : null;
        $this->container['purge_state'] = isset($data['purge_state']) ? $data['purge_state'] : null;
        $this->container['recipients'] = isset($data['recipients']) ? $data['recipients'] : null;
        $this->container['recipients_lock'] = isset($data['recipients_lock']) ? $data['recipients_lock'] : null;
        $this->container['recipients_uri'] = isset($data['recipients_uri']) ? $data['recipients_uri'] : null;
        $this->container['sent_date_time'] = isset($data['sent_date_time']) ? $data['sent_date_time'] : null;
        $this->container['shared'] = isset($data['shared']) ? $data['shared'] : null;
        $this->container['signing_location'] = isset($data['signing_location']) ? $data['signing_location'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['status_changed_date_time'] = isset($data['status_changed_date_time']) ? $data['status_changed_date_time'] : null;
        $this->container['template_id'] = isset($data['template_id']) ? $data['template_id'] : null;
        $this->container['templates_uri'] = isset($data['templates_uri']) ? $data['templates_uri'] : null;
        $this->container['transaction_id'] = isset($data['transaction_id']) ? $data['transaction_id'] : null;
        $this->container['uri'] = isset($data['uri']) ? $data['uri'] : null;
        $this->container['use_disclosure'] = isset($data['use_disclosure']) ? $data['use_disclosure'] : null;
        $this->container['voided_date_time'] = isset($data['voided_date_time']) ? $data['voided_date_time'] : null;
        $this->container['voided_reason'] = isset($data['voided_reason']) ? $data['voided_reason'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets allow_markup
     * @return string
     */
    public function getAllowMarkup()
    {
        return $this->container['allow_markup'];
    }

    /**
     * Sets allow_markup
     * @param string $allow_markup When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this
     * @return $this
     */
    public function setAllowMarkup($allow_markup)
    {
        $this->container['allow_markup'] = $allow_markup;

        return $this;
    }

    /**
     * Gets allow_reassign
     * @return string
     */
    public function getAllowReassign()
    {
        return $this->container['allow_reassign'];
    }

    /**
     * Sets allow_reassign
     * @param string $allow_reassign When set to **true**, the recipient can redirect an envelope to a more appropriate recipient.
     * @return $this
     */
    public function setAllowReassign($allow_reassign)
    {
        $this->container['allow_reassign'] = $allow_reassign;

        return $this;
    }

    /**
     * Gets asynchronous
     * @return string
     */
    public function getAsynchronous()
    {
        return $this->container['asynchronous'];
    }

    /**
     * Sets asynchronous
     * @param string $asynchronous When set to **true**, the envelope is queued for processing and the value of the `status` property is set to 'Processing'. Additionally, get status calls return 'Processing' until completed.
     * @return $this
     */
    public function setAsynchronous($asynchronous)
    {
        $this->container['asynchronous'] = $asynchronous;

        return $this;
    }

    /**
     * Gets attachments_uri
     * @return string
     */
    public function getAttachmentsUri()
    {
        return $this->container['attachments_uri'];
    }

    /**
     * Sets attachments_uri
     * @param string $attachments_uri 
     * @return $this
     */
    public function setAttachmentsUri($attachments_uri)
    {
        $this->container['attachments_uri'] = $attachments_uri;

        return $this;
    }

    /**
     * Gets authoritative_copy
     * @return string
     */
    public function getAuthoritativeCopy()
    {
        return $this->container['authoritative_copy'];
    }

    /**
     * Sets authoritative_copy
     * @param string $authoritative_copy Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is enabled.
     * @return $this
     */
    public function setAuthoritativeCopy($authoritative_copy)
    {
        $this->container['authoritative_copy'] = $authoritative_copy;

        return $this;
    }

    /**
     * Gets auto_navigation
     * @return string
     */
    public function getAutoNavigation()
    {
        return $this->container['auto_navigation'];
    }

    /**
     * Sets auto_navigation
     * @param string $auto_navigation 
     * @return $this
     */
    public function setAutoNavigation($auto_navigation)
    {
        $this->container['auto_navigation'] = $auto_navigation;

        return $this;
    }

    /**
     * Gets brand_id
     * @return string
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     * @param string $brand_id 
     * @return $this
     */
    public function setBrandId($brand_id)
    {
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets brand_lock
     * @return string
     */
    public function getBrandLock()
    {
        return $this->container['brand_lock'];
    }

    /**
     * Sets brand_lock
     * @param string $brand_lock 
     * @return $this
     */
    public function setBrandLock($brand_lock)
    {
        $this->container['brand_lock'] = $brand_lock;

        return $this;
    }

    /**
     * Gets certificate_uri
     * @return string
     */
    public function getCertificateUri()
    {
        return $this->container['certificate_uri'];
    }

    /**
     * Sets certificate_uri
     * @param string $certificate_uri Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.
     * @return $this
     */
    public function setCertificateUri($certificate_uri)
    {
        $this->container['certificate_uri'] = $certificate_uri;

        return $this;
    }

    /**
     * Gets completed_date_time
     * @return string
     */
    public function getCompletedDateTime()
    {
        return $this->container['completed_date_time'];
    }

    /**
     * Sets completed_date_time
     * @param string $completed_date_time Specifies the date and time this item was completed.
     * @return $this
     */
    public function setCompletedDateTime($completed_date_time)
    {
        $this->container['completed_date_time'] = $completed_date_time;

        return $this;
    }

    /**
     * Gets created_date_time
     * @return string
     */
    public function getCreatedDateTime()
    {
        return $this->container['created_date_time'];
    }

    /**
     * Sets created_date_time
     * @param string $created_date_time Indicates the date and time the item was created.
     * @return $this
     */
    public function setCreatedDateTime($created_date_time)
    {
        $this->container['created_date_time'] = $created_date_time;

        return $this;
    }

    /**
     * Gets custom_fields
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function getCustomFields()
    {
        return $this->container['custom_fields'];
    }

    /**
     * Sets custom_fields
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields
     * @return $this
     */
    public function setCustomFields($custom_fields)
    {
        $this->container['custom_fields'] = $custom_fields;

        return $this;
    }

    /**
     * Gets custom_fields_uri
     * @return string
     */
    public function getCustomFieldsUri()
    {
        return $this->container['custom_fields_uri'];
    }

    /**
     * Sets custom_fields_uri
     * @param string $custom_fields_uri Contains a URI for an endpoint that you can use to retrieve the custom fields.
     * @return $this
     */
    public function setCustomFieldsUri($custom_fields_uri)
    {
        $this->container['custom_fields_uri'] = $custom_fields_uri;

        return $this;
    }

    /**
     * Gets declined_date_time
     * @return string
     */
    public function getDeclinedDateTime()
    {
        return $this->container['declined_date_time'];
    }

    /**
     * Sets declined_date_time
     * @param string $declined_date_time The date and time the recipient declined the document.
     * @return $this
     */
    public function setDeclinedDateTime($declined_date_time)
    {
        $this->container['declined_date_time'] = $declined_date_time;

        return $this;
    }

    /**
     * Gets deleted_date_time
     * @return string
     */
    public function getDeletedDateTime()
    {
        return $this->container['deleted_date_time'];
    }

    /**
     * Sets deleted_date_time
     * @param string $deleted_date_time Specifies the data and time the item was deleted.
     * @return $this
     */
    public function setDeletedDateTime($deleted_date_time)
    {
        $this->container['deleted_date_time'] = $deleted_date_time;

        return $this;
    }

    /**
     * Gets delivered_date_time
     * @return string
     */
    public function getDeliveredDateTime()
    {
        return $this->container['delivered_date_time'];
    }

    /**
     * Sets delivered_date_time
     * @param string $delivered_date_time Reserved: For DocuSign use only.
     * @return $this
     */
    public function setDeliveredDateTime($delivered_date_time)
    {
        $this->container['delivered_date_time'] = $delivered_date_time;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description 
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets documents
     * @return \DocuSign\eSign\Model\Document[]
     */
    public function getDocuments()
    {
        return $this->container['documents'];
    }

    /**
     * Sets documents
     * @param \DocuSign\eSign\Model\Document[] $documents Complex element contains the details on the documents in the envelope.
     * @return $this
     */
    public function setDocuments($documents)
    {
        $this->container['documents'] = $documents;

        return $this;
    }

    /**
     * Gets documents_combined_uri
     * @return string
     */
    public function getDocumentsCombinedUri()
    {
        return $this->container['documents_combined_uri'];
    }

    /**
     * Sets documents_combined_uri
     * @param string $documents_combined_uri 
     * @return $this
     */
    public function setDocumentsCombinedUri($documents_combined_uri)
    {
        $this->container['documents_combined_uri'] = $documents_combined_uri;

        return $this;
    }

    /**
     * Gets documents_uri
     * @return string
     */
    public function getDocumentsUri()
    {
        return $this->container['documents_uri'];
    }

    /**
     * Sets documents_uri
     * @param string $documents_uri Contains a URI for an endpoint that you can use to retrieve the documents.
     * @return $this
     */
    public function setDocumentsUri($documents_uri)
    {
        $this->container['documents_uri'] = $documents_uri;

        return $this;
    }

    /**
     * Gets email_blurb
     * @return string
     */
    public function getEmailBlurb()
    {
        return $this->container['email_blurb'];
    }

    /**
     * Sets email_blurb
     * @param string $email_blurb 
     * @return $this
     */
    public function setEmailBlurb($email_blurb)
    {
        $this->container['email_blurb'] = $email_blurb;

        return $this;
    }

    /**
     * Gets email_settings
     * @return \DocuSign\eSign\Model\EmailSettings
     */
    public function getEmailSettings()
    {
        return $this->container['email_settings'];
    }

    /**
     * Sets email_settings
     * @param \DocuSign\eSign\Model\EmailSettings $email_settings
     * @return $this
     */
    public function setEmailSettings($email_settings)
    {
        $this->container['email_settings'] = $email_settings;

        return $this;
    }

    /**
     * Gets email_subject
     * @return string
     */
    public function getEmailSubject()
    {
        return $this->container['email_subject'];
    }

    /**
     * Sets email_subject
     * @param string $email_subject Specifies the subject of the email that is sent to all recipients.  See [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.
     * @return $this
     */
    public function setEmailSubject($email_subject)
    {
        $this->container['email_subject'] = $email_subject;

        return $this;
    }

    /**
     * Gets enable_wet_sign
     * @return string
     */
    public function getEnableWetSign()
    {
        return $this->container['enable_wet_sign'];
    }

    /**
     * Sets enable_wet_sign
     * @param string $enable_wet_sign When set to **true**, the signer is allowed to print the document and sign it on paper.
     * @return $this
     */
    public function setEnableWetSign($enable_wet_sign)
    {
        $this->container['enable_wet_sign'] = $enable_wet_sign;

        return $this;
    }

    /**
     * Gets enforce_signer_visibility
     * @return string
     */
    public function getEnforceSignerVisibility()
    {
        return $this->container['enforce_signer_visibility'];
    }

    /**
     * Sets enforce_signer_visibility
     * @param string $enforce_signer_visibility When set to **true**, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.  Your account must have Document Visibility enabled to use this.
     * @return $this
     */
    public function setEnforceSignerVisibility($enforce_signer_visibility)
    {
        $this->container['enforce_signer_visibility'] = $enforce_signer_visibility;

        return $this;
    }

    /**
     * Gets envelope_id
     * @return string
     */
    public function getEnvelopeId()
    {
        return $this->container['envelope_id'];
    }

    /**
     * Sets envelope_id
     * @param string $envelope_id The envelope ID of the envelope status that failed to post.
     * @return $this
     */
    public function setEnvelopeId($envelope_id)
    {
        $this->container['envelope_id'] = $envelope_id;

        return $this;
    }

    /**
     * Gets envelope_id_stamping
     * @return string
     */
    public function getEnvelopeIdStamping()
    {
        return $this->container['envelope_id_stamping'];
    }

    /**
     * Sets envelope_id_stamping
     * @param string $envelope_id_stamping When set to **true**, Envelope ID Stamping is enabled.
     * @return $this
     */
    public function setEnvelopeIdStamping($envelope_id_stamping)
    {
        $this->container['envelope_id_stamping'] = $envelope_id_stamping;

        return $this;
    }

    /**
     * Gets envelope_uri
     * @return string
     */
    public function getEnvelopeUri()
    {
        return $this->container['envelope_uri'];
    }

    /**
     * Sets envelope_uri
     * @param string $envelope_uri Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.
     * @return $this
     */
    public function setEnvelopeUri($envelope_uri)
    {
        $this->container['envelope_uri'] = $envelope_uri;

        return $this;
    }

    /**
     * Gets folder_id
     * @return string
     */
    public function getFolderId()
    {
        return $this->container['folder_id'];
    }

    /**
     * Sets folder_id
     * @param string $folder_id 
     * @return $this
     */
    public function setFolderId($folder_id)
    {
        $this->container['folder_id'] = $folder_id;

        return $this;
    }

    /**
     * Gets folder_name
     * @return string
     */
    public function getFolderName()
    {
        return $this->container['folder_name'];
    }

    /**
     * Sets folder_name
     * @param string $folder_name 
     * @return $this
     */
    public function setFolderName($folder_name)
    {
        $this->container['folder_name'] = $folder_name;

        return $this;
    }

    /**
     * Gets folder_uri
     * @return string
     */
    public function getFolderUri()
    {
        return $this->container['folder_uri'];
    }

    /**
     * Sets folder_uri
     * @param string $folder_uri 
     * @return $this
     */
    public function setFolderUri($folder_uri)
    {
        $this->container['folder_uri'] = $folder_uri;

        return $this;
    }

    /**
     * Gets initial_sent_date_time
     * @return string
     */
    public function getInitialSentDateTime()
    {
        return $this->container['initial_sent_date_time'];
    }

    /**
     * Sets initial_sent_date_time
     * @param string $initial_sent_date_time 
     * @return $this
     */
    public function setInitialSentDateTime($initial_sent_date_time)
    {
        $this->container['initial_sent_date_time'] = $initial_sent_date_time;

        return $this;
    }

    /**
     * Gets is21_cfr_part11
     * @return string
     */
    public function getIs21CfrPart11()
    {
        return $this->container['is21_cfr_part11'];
    }

    /**
     * Sets is21_cfr_part11
     * @param string $is21_cfr_part11 When set to **true**, indicates that this module is enabled on the account.
     * @return $this
     */
    public function setIs21CfrPart11($is21_cfr_part11)
    {
        $this->container['is21_cfr_part11'] = $is21_cfr_part11;

        return $this;
    }

    /**
     * Gets is_signature_provider_envelope
     * @return string
     */
    public function getIsSignatureProviderEnvelope()
    {
        return $this->container['is_signature_provider_envelope'];
    }

    /**
     * Sets is_signature_provider_envelope
     * @param string $is_signature_provider_envelope 
     * @return $this
     */
    public function setIsSignatureProviderEnvelope($is_signature_provider_envelope)
    {
        $this->container['is_signature_provider_envelope'] = $is_signature_provider_envelope;

        return $this;
    }

    /**
     * Gets last_modified
     * @return string
     */
    public function getLastModified()
    {
        return $this->container['last_modified'];
    }

    /**
     * Sets last_modified
     * @param string $last_modified 
     * @return $this
     */
    public function setLastModified($last_modified)
    {
        $this->container['last_modified'] = $last_modified;

        return $this;
    }

    /**
     * Gets last_modified_date_time
     * @return string
     */
    public function getLastModifiedDateTime()
    {
        return $this->container['last_modified_date_time'];
    }

    /**
     * Sets last_modified_date_time
     * @param string $last_modified_date_time The date and time the item was last modified.
     * @return $this
     */
    public function setLastModifiedDateTime($last_modified_date_time)
    {
        $this->container['last_modified_date_time'] = $last_modified_date_time;

        return $this;
    }

    /**
     * Gets lock_information
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function getLockInformation()
    {
        return $this->container['lock_information'];
    }

    /**
     * Sets lock_information
     * @param \DocuSign\eSign\Model\LockInformation $lock_information
     * @return $this
     */
    public function setLockInformation($lock_information)
    {
        $this->container['lock_information'] = $lock_information;

        return $this;
    }

    /**
     * Gets message_lock
     * @return string
     */
    public function getMessageLock()
    {
        return $this->container['message_lock'];
    }

    /**
     * Sets message_lock
     * @param string $message_lock When set to **true**, prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope.   Additionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes.   However, if the `messageLock` node is set to true**** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.
     * @return $this
     */
    public function setMessageLock($message_lock)
    {
        $this->container['message_lock'] = $message_lock;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name 
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets notification
     * @return \DocuSign\eSign\Model\Notification
     */
    public function getNotification()
    {
        return $this->container['notification'];
    }

    /**
     * Sets notification
     * @param \DocuSign\eSign\Model\Notification $notification
     * @return $this
     */
    public function setNotification($notification)
    {
        $this->container['notification'] = $notification;

        return $this;
    }

    /**
     * Gets notification_uri
     * @return string
     */
    public function getNotificationUri()
    {
        return $this->container['notification_uri'];
    }

    /**
     * Sets notification_uri
     * @param string $notification_uri Contains a URI for an endpoint that you can use to retrieve the notifications.
     * @return $this
     */
    public function setNotificationUri($notification_uri)
    {
        $this->container['notification_uri'] = $notification_uri;

        return $this;
    }

    /**
     * Gets owner
     * @return \DocuSign\eSign\Model\UserInfo
     */
    public function getOwner()
    {
        return $this->container['owner'];
    }

    /**
     * Sets owner
     * @param \DocuSign\eSign\Model\UserInfo $owner
     * @return $this
     */
    public function setOwner($owner)
    {
        $this->container['owner'] = $owner;

        return $this;
    }

    /**
     * Gets page_count
     * @return int
     */
    public function getPageCount()
    {
        return $this->container['page_count'];
    }

    /**
     * Sets page_count
     * @param int $page_count 
     * @return $this
     */
    public function setPageCount($page_count)
    {
        $this->container['page_count'] = $page_count;

        return $this;
    }

    /**
     * Gets parent_folder_uri
     * @return string
     */
    public function getParentFolderUri()
    {
        return $this->container['parent_folder_uri'];
    }

    /**
     * Sets parent_folder_uri
     * @param string $parent_folder_uri 
     * @return $this
     */
    public function setParentFolderUri($parent_folder_uri)
    {
        $this->container['parent_folder_uri'] = $parent_folder_uri;

        return $this;
    }

    /**
     * Gets password
     * @return string
     */
    public function getPassword()
    {
        return $this->container['password'];
    }

    /**
     * Sets password
     * @param string $password 
     * @return $this
     */
    public function setPassword($password)
    {
        $this->container['password'] = $password;

        return $this;
    }

    /**
     * Gets purge_state
     * @return string
     */
    public function getPurgeState()
    {
        return $this->container['purge_state'];
    }

    /**
     * Sets purge_state
     * @param string $purge_state 
     * @return $this
     */
    public function setPurgeState($purge_state)
    {
        $this->container['purge_state'] = $purge_state;

        return $this;
    }

    /**
     * Gets recipients
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function getRecipients()
    {
        return $this->container['recipients'];
    }

    /**
     * Sets recipients
     * @param \DocuSign\eSign\Model\Recipients $recipients
     * @return $this
     */
    public function setRecipients($recipients)
    {
        $this->container['recipients'] = $recipients;

        return $this;
    }

    /**
     * Gets recipients_lock
     * @return string
     */
    public function getRecipientsLock()
    {
        return $this->container['recipients_lock'];
    }

    /**
     * Sets recipients_lock
     * @param string $recipients_lock When set to **true**, prevents senders from changing, correcting, or deleting the recipient information for the envelope.
     * @return $this
     */
    public function setRecipientsLock($recipients_lock)
    {
        $this->container['recipients_lock'] = $recipients_lock;

        return $this;
    }

    /**
     * Gets recipients_uri
     * @return string
     */
    public function getRecipientsUri()
    {
        return $this->container['recipients_uri'];
    }

    /**
     * Sets recipients_uri
     * @param string $recipients_uri Contains a URI for an endpoint that you can use to retrieve the recipients.
     * @return $this
     */
    public function setRecipientsUri($recipients_uri)
    {
        $this->container['recipients_uri'] = $recipients_uri;

        return $this;
    }

    /**
     * Gets sent_date_time
     * @return string
     */
    public function getSentDateTime()
    {
        return $this->container['sent_date_time'];
    }

    /**
     * Sets sent_date_time
     * @param string $sent_date_time The date and time the envelope was sent.
     * @return $this
     */
    public function setSentDateTime($sent_date_time)
    {
        $this->container['sent_date_time'] = $sent_date_time;

        return $this;
    }

    /**
     * Gets shared
     * @return string
     */
    public function getShared()
    {
        return $this->container['shared'];
    }

    /**
     * Sets shared
     * @param string $shared When set to **true**, this custom tab is shared.
     * @return $this
     */
    public function setShared($shared)
    {
        $this->container['shared'] = $shared;

        return $this;
    }

    /**
     * Gets signing_location
     * @return string
     */
    public function getSigningLocation()
    {
        return $this->container['signing_location'];
    }

    /**
     * Sets signing_location
     * @param string $signing_location Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.
     * @return $this
     */
    public function setSigningLocation($signing_location)
    {
        $this->container['signing_location'] = $signing_location;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets status_changed_date_time
     * @return string
     */
    public function getStatusChangedDateTime()
    {
        return $this->container['status_changed_date_time'];
    }

    /**
     * Sets status_changed_date_time
     * @param string $status_changed_date_time The data and time the status changed.
     * @return $this
     */
    public function setStatusChangedDateTime($status_changed_date_time)
    {
        $this->container['status_changed_date_time'] = $status_changed_date_time;

        return $this;
    }

    /**
     * Gets template_id
     * @return string
     */
    public function getTemplateId()
    {
        return $this->container['template_id'];
    }

    /**
     * Sets template_id
     * @param string $template_id The unique identifier of the template. If this is not provided, DocuSign will generate a value.
     * @return $this
     */
    public function setTemplateId($template_id)
    {
        $this->container['template_id'] = $template_id;

        return $this;
    }

    /**
     * Gets templates_uri
     * @return string
     */
    public function getTemplatesUri()
    {
        return $this->container['templates_uri'];
    }

    /**
     * Sets templates_uri
     * @param string $templates_uri Contains a URI for an endpoint which you can use to retrieve the templates.
     * @return $this
     */
    public function setTemplatesUri($templates_uri)
    {
        $this->container['templates_uri'] = $templates_uri;

        return $this;
    }

    /**
     * Gets transaction_id
     * @return string
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     * @param string $transaction_id Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.
     * @return $this
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets uri
     * @return string
     */
    public function getUri()
    {
        return $this->container['uri'];
    }

    /**
     * Sets uri
     * @param string $uri 
     * @return $this
     */
    public function setUri($uri)
    {
        $this->container['uri'] = $uri;

        return $this;
    }

    /**
     * Gets use_disclosure
     * @return string
     */
    public function getUseDisclosure()
    {
        return $this->container['use_disclosure'];
    }

    /**
     * Sets use_disclosure
     * @param string $use_disclosure When set to **true**, the disclosure is shown to recipients in accordance with the account’s Electronic Record and Signature Disclosure frequency setting. When set to **false**, the Electronic Record and Signature Disclosure is not shown to any envelope recipients.   If the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.
     * @return $this
     */
    public function setUseDisclosure($use_disclosure)
    {
        $this->container['use_disclosure'] = $use_disclosure;

        return $this;
    }

    /**
     * Gets voided_date_time
     * @return string
     */
    public function getVoidedDateTime()
    {
        return $this->container['voided_date_time'];
    }

    /**
     * Sets voided_date_time
     * @param string $voided_date_time The date and time the envelope or template was voided.
     * @return $this
     */
    public function setVoidedDateTime($voided_date_time)
    {
        $this->container['voided_date_time'] = $voided_date_time;

        return $this;
    }

    /**
     * Gets voided_reason
     * @return string
     */
    public function getVoidedReason()
    {
        return $this->container['voided_reason'];
    }

    /**
     * Sets voided_reason
     * @param string $voided_reason The reason the envelope or template was voided.
     * @return $this
     */
    public function setVoidedReason($voided_reason)
    {
        $this->container['voided_reason'] = $voided_reason;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this));
    }
}


