<?php
/**
 * InPersonSigner
 *
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;

/**
 * InPersonSigner Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class InPersonSigner implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'inPersonSigner';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'access_code' => 'string',
        'add_access_code_to_email' => 'string',
        'auto_navigation' => 'string',
        'can_sign_offline' => 'string',
        'client_user_id' => 'string',
        'custom_fields' => 'string[]',
        'declined_date_time' => 'string',
        'declined_reason' => 'string',
        'default_recipient' => 'string',
        'delivered_date_time' => 'string',
        'delivery_method' => 'string',
        'document_visibility' => '\DocuSign\eSign\Model\DocumentVisibility[]',
        'email_notification' => '\DocuSign\eSign\Model\RecipientEmailNotification',
        'embedded_recipient_start_url' => 'string',
        'error_details' => '\DocuSign\eSign\Model\ErrorDetails',
        'fax_number' => 'string',
        'host_email' => 'string',
        'host_name' => 'string',
        'id_check_configuration_name' => 'string',
        'id_check_information_input' => '\DocuSign\eSign\Model\IdCheckInformationInput',
        'inherit_email_notification_configuration' => 'string',
        'in_person_signing_type' => 'string',
        'notary_host' => '\DocuSign\eSign\Model\NotaryHost',
        'note' => 'string',
        'offline_attributes' => '\DocuSign\eSign\Model\OfflineAttributes',
        'phone_authentication' => '\DocuSign\eSign\Model\RecipientPhoneAuthentication',
        'recipient_attachments' => '\DocuSign\eSign\Model\RecipientAttachment[]',
        'recipient_authentication_status' => '\DocuSign\eSign\Model\AuthenticationStatus',
        'recipient_id' => 'string',
        'recipient_id_guid' => 'string',
        'recipient_signature_providers' => '\DocuSign\eSign\Model\RecipientSignatureProvider[]',
        'recipient_supplies_tabs' => 'string',
        'require_id_lookup' => 'string',
        'require_signer_certificate' => 'string',
        'require_sign_on_paper' => 'string',
        'role_name' => 'string',
        'routing_order' => 'string',
        'saml_authentication' => '\DocuSign\eSign\Model\RecipientSAMLAuthentication',
        'sent_date_time' => 'string',
        'signature_info' => '\DocuSign\eSign\Model\RecipientSignatureInformation',
        'signed_date_time' => 'string',
        'signer_email' => 'string',
        'signer_name' => 'string',
        'sign_in_each_location' => 'string',
        'signing_group_id' => 'string',
        'signing_group_name' => 'string',
        'signing_group_users' => '\DocuSign\eSign\Model\UserInfo[]',
        'sms_authentication' => '\DocuSign\eSign\Model\RecipientSMSAuthentication',
        'social_authentications' => '\DocuSign\eSign\Model\SocialAuthentication[]',
        'status' => 'string',
        'tabs' => '\DocuSign\eSign\Model\Tabs',
        'template_locked' => 'string',
        'template_required' => 'string',
        'total_tab_count' => 'string',
        'user_id' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'access_code' => 'accessCode',
        'add_access_code_to_email' => 'addAccessCodeToEmail',
        'auto_navigation' => 'autoNavigation',
        'can_sign_offline' => 'canSignOffline',
        'client_user_id' => 'clientUserId',
        'custom_fields' => 'customFields',
        'declined_date_time' => 'declinedDateTime',
        'declined_reason' => 'declinedReason',
        'default_recipient' => 'defaultRecipient',
        'delivered_date_time' => 'deliveredDateTime',
        'delivery_method' => 'deliveryMethod',
        'document_visibility' => 'documentVisibility',
        'email_notification' => 'emailNotification',
        'embedded_recipient_start_url' => 'embeddedRecipientStartURL',
        'error_details' => 'errorDetails',
        'fax_number' => 'faxNumber',
        'host_email' => 'hostEmail',
        'host_name' => 'hostName',
        'id_check_configuration_name' => 'idCheckConfigurationName',
        'id_check_information_input' => 'idCheckInformationInput',
        'inherit_email_notification_configuration' => 'inheritEmailNotificationConfiguration',
        'in_person_signing_type' => 'inPersonSigningType',
        'notary_host' => 'notaryHost',
        'note' => 'note',
        'offline_attributes' => 'offlineAttributes',
        'phone_authentication' => 'phoneAuthentication',
        'recipient_attachments' => 'recipientAttachments',
        'recipient_authentication_status' => 'recipientAuthenticationStatus',
        'recipient_id' => 'recipientId',
        'recipient_id_guid' => 'recipientIdGuid',
        'recipient_signature_providers' => 'recipientSignatureProviders',
        'recipient_supplies_tabs' => 'recipientSuppliesTabs',
        'require_id_lookup' => 'requireIdLookup',
        'require_signer_certificate' => 'requireSignerCertificate',
        'require_sign_on_paper' => 'requireSignOnPaper',
        'role_name' => 'roleName',
        'routing_order' => 'routingOrder',
        'saml_authentication' => 'samlAuthentication',
        'sent_date_time' => 'sentDateTime',
        'signature_info' => 'signatureInfo',
        'signed_date_time' => 'signedDateTime',
        'signer_email' => 'signerEmail',
        'signer_name' => 'signerName',
        'sign_in_each_location' => 'signInEachLocation',
        'signing_group_id' => 'signingGroupId',
        'signing_group_name' => 'signingGroupName',
        'signing_group_users' => 'signingGroupUsers',
        'sms_authentication' => 'smsAuthentication',
        'social_authentications' => 'socialAuthentications',
        'status' => 'status',
        'tabs' => 'tabs',
        'template_locked' => 'templateLocked',
        'template_required' => 'templateRequired',
        'total_tab_count' => 'totalTabCount',
        'user_id' => 'userId'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'access_code' => 'setAccessCode',
        'add_access_code_to_email' => 'setAddAccessCodeToEmail',
        'auto_navigation' => 'setAutoNavigation',
        'can_sign_offline' => 'setCanSignOffline',
        'client_user_id' => 'setClientUserId',
        'custom_fields' => 'setCustomFields',
        'declined_date_time' => 'setDeclinedDateTime',
        'declined_reason' => 'setDeclinedReason',
        'default_recipient' => 'setDefaultRecipient',
        'delivered_date_time' => 'setDeliveredDateTime',
        'delivery_method' => 'setDeliveryMethod',
        'document_visibility' => 'setDocumentVisibility',
        'email_notification' => 'setEmailNotification',
        'embedded_recipient_start_url' => 'setEmbeddedRecipientStartUrl',
        'error_details' => 'setErrorDetails',
        'fax_number' => 'setFaxNumber',
        'host_email' => 'setHostEmail',
        'host_name' => 'setHostName',
        'id_check_configuration_name' => 'setIdCheckConfigurationName',
        'id_check_information_input' => 'setIdCheckInformationInput',
        'inherit_email_notification_configuration' => 'setInheritEmailNotificationConfiguration',
        'in_person_signing_type' => 'setInPersonSigningType',
        'notary_host' => 'setNotaryHost',
        'note' => 'setNote',
        'offline_attributes' => 'setOfflineAttributes',
        'phone_authentication' => 'setPhoneAuthentication',
        'recipient_attachments' => 'setRecipientAttachments',
        'recipient_authentication_status' => 'setRecipientAuthenticationStatus',
        'recipient_id' => 'setRecipientId',
        'recipient_id_guid' => 'setRecipientIdGuid',
        'recipient_signature_providers' => 'setRecipientSignatureProviders',
        'recipient_supplies_tabs' => 'setRecipientSuppliesTabs',
        'require_id_lookup' => 'setRequireIdLookup',
        'require_signer_certificate' => 'setRequireSignerCertificate',
        'require_sign_on_paper' => 'setRequireSignOnPaper',
        'role_name' => 'setRoleName',
        'routing_order' => 'setRoutingOrder',
        'saml_authentication' => 'setSamlAuthentication',
        'sent_date_time' => 'setSentDateTime',
        'signature_info' => 'setSignatureInfo',
        'signed_date_time' => 'setSignedDateTime',
        'signer_email' => 'setSignerEmail',
        'signer_name' => 'setSignerName',
        'sign_in_each_location' => 'setSignInEachLocation',
        'signing_group_id' => 'setSigningGroupId',
        'signing_group_name' => 'setSigningGroupName',
        'signing_group_users' => 'setSigningGroupUsers',
        'sms_authentication' => 'setSmsAuthentication',
        'social_authentications' => 'setSocialAuthentications',
        'status' => 'setStatus',
        'tabs' => 'setTabs',
        'template_locked' => 'setTemplateLocked',
        'template_required' => 'setTemplateRequired',
        'total_tab_count' => 'setTotalTabCount',
        'user_id' => 'setUserId'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'access_code' => 'getAccessCode',
        'add_access_code_to_email' => 'getAddAccessCodeToEmail',
        'auto_navigation' => 'getAutoNavigation',
        'can_sign_offline' => 'getCanSignOffline',
        'client_user_id' => 'getClientUserId',
        'custom_fields' => 'getCustomFields',
        'declined_date_time' => 'getDeclinedDateTime',
        'declined_reason' => 'getDeclinedReason',
        'default_recipient' => 'getDefaultRecipient',
        'delivered_date_time' => 'getDeliveredDateTime',
        'delivery_method' => 'getDeliveryMethod',
        'document_visibility' => 'getDocumentVisibility',
        'email_notification' => 'getEmailNotification',
        'embedded_recipient_start_url' => 'getEmbeddedRecipientStartUrl',
        'error_details' => 'getErrorDetails',
        'fax_number' => 'getFaxNumber',
        'host_email' => 'getHostEmail',
        'host_name' => 'getHostName',
        'id_check_configuration_name' => 'getIdCheckConfigurationName',
        'id_check_information_input' => 'getIdCheckInformationInput',
        'inherit_email_notification_configuration' => 'getInheritEmailNotificationConfiguration',
        'in_person_signing_type' => 'getInPersonSigningType',
        'notary_host' => 'getNotaryHost',
        'note' => 'getNote',
        'offline_attributes' => 'getOfflineAttributes',
        'phone_authentication' => 'getPhoneAuthentication',
        'recipient_attachments' => 'getRecipientAttachments',
        'recipient_authentication_status' => 'getRecipientAuthenticationStatus',
        'recipient_id' => 'getRecipientId',
        'recipient_id_guid' => 'getRecipientIdGuid',
        'recipient_signature_providers' => 'getRecipientSignatureProviders',
        'recipient_supplies_tabs' => 'getRecipientSuppliesTabs',
        'require_id_lookup' => 'getRequireIdLookup',
        'require_signer_certificate' => 'getRequireSignerCertificate',
        'require_sign_on_paper' => 'getRequireSignOnPaper',
        'role_name' => 'getRoleName',
        'routing_order' => 'getRoutingOrder',
        'saml_authentication' => 'getSamlAuthentication',
        'sent_date_time' => 'getSentDateTime',
        'signature_info' => 'getSignatureInfo',
        'signed_date_time' => 'getSignedDateTime',
        'signer_email' => 'getSignerEmail',
        'signer_name' => 'getSignerName',
        'sign_in_each_location' => 'getSignInEachLocation',
        'signing_group_id' => 'getSigningGroupId',
        'signing_group_name' => 'getSigningGroupName',
        'signing_group_users' => 'getSigningGroupUsers',
        'sms_authentication' => 'getSmsAuthentication',
        'social_authentications' => 'getSocialAuthentications',
        'status' => 'getStatus',
        'tabs' => 'getTabs',
        'template_locked' => 'getTemplateLocked',
        'template_required' => 'getTemplateRequired',
        'total_tab_count' => 'getTotalTabCount',
        'user_id' => 'getUserId'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['access_code'] = isset($data['access_code']) ? $data['access_code'] : null;
        $this->container['add_access_code_to_email'] = isset($data['add_access_code_to_email']) ? $data['add_access_code_to_email'] : null;
        $this->container['auto_navigation'] = isset($data['auto_navigation']) ? $data['auto_navigation'] : null;
        $this->container['can_sign_offline'] = isset($data['can_sign_offline']) ? $data['can_sign_offline'] : null;
        $this->container['client_user_id'] = isset($data['client_user_id']) ? $data['client_user_id'] : null;
        $this->container['custom_fields'] = isset($data['custom_fields']) ? $data['custom_fields'] : null;
        $this->container['declined_date_time'] = isset($data['declined_date_time']) ? $data['declined_date_time'] : null;
        $this->container['declined_reason'] = isset($data['declined_reason']) ? $data['declined_reason'] : null;
        $this->container['default_recipient'] = isset($data['default_recipient']) ? $data['default_recipient'] : null;
        $this->container['delivered_date_time'] = isset($data['delivered_date_time']) ? $data['delivered_date_time'] : null;
        $this->container['delivery_method'] = isset($data['delivery_method']) ? $data['delivery_method'] : null;
        $this->container['document_visibility'] = isset($data['document_visibility']) ? $data['document_visibility'] : null;
        $this->container['email_notification'] = isset($data['email_notification']) ? $data['email_notification'] : null;
        $this->container['embedded_recipient_start_url'] = isset($data['embedded_recipient_start_url']) ? $data['embedded_recipient_start_url'] : null;
        $this->container['error_details'] = isset($data['error_details']) ? $data['error_details'] : null;
        $this->container['fax_number'] = isset($data['fax_number']) ? $data['fax_number'] : null;
        $this->container['host_email'] = isset($data['host_email']) ? $data['host_email'] : null;
        $this->container['host_name'] = isset($data['host_name']) ? $data['host_name'] : null;
        $this->container['id_check_configuration_name'] = isset($data['id_check_configuration_name']) ? $data['id_check_configuration_name'] : null;
        $this->container['id_check_information_input'] = isset($data['id_check_information_input']) ? $data['id_check_information_input'] : null;
        $this->container['inherit_email_notification_configuration'] = isset($data['inherit_email_notification_configuration']) ? $data['inherit_email_notification_configuration'] : null;
        $this->container['in_person_signing_type'] = isset($data['in_person_signing_type']) ? $data['in_person_signing_type'] : null;
        $this->container['notary_host'] = isset($data['notary_host']) ? $data['notary_host'] : null;
        $this->container['note'] = isset($data['note']) ? $data['note'] : null;
        $this->container['offline_attributes'] = isset($data['offline_attributes']) ? $data['offline_attributes'] : null;
        $this->container['phone_authentication'] = isset($data['phone_authentication']) ? $data['phone_authentication'] : null;
        $this->container['recipient_attachments'] = isset($data['recipient_attachments']) ? $data['recipient_attachments'] : null;
        $this->container['recipient_authentication_status'] = isset($data['recipient_authentication_status']) ? $data['recipient_authentication_status'] : null;
        $this->container['recipient_id'] = isset($data['recipient_id']) ? $data['recipient_id'] : null;
        $this->container['recipient_id_guid'] = isset($data['recipient_id_guid']) ? $data['recipient_id_guid'] : null;
        $this->container['recipient_signature_providers'] = isset($data['recipient_signature_providers']) ? $data['recipient_signature_providers'] : null;
        $this->container['recipient_supplies_tabs'] = isset($data['recipient_supplies_tabs']) ? $data['recipient_supplies_tabs'] : null;
        $this->container['require_id_lookup'] = isset($data['require_id_lookup']) ? $data['require_id_lookup'] : null;
        $this->container['require_signer_certificate'] = isset($data['require_signer_certificate']) ? $data['require_signer_certificate'] : null;
        $this->container['require_sign_on_paper'] = isset($data['require_sign_on_paper']) ? $data['require_sign_on_paper'] : null;
        $this->container['role_name'] = isset($data['role_name']) ? $data['role_name'] : null;
        $this->container['routing_order'] = isset($data['routing_order']) ? $data['routing_order'] : null;
        $this->container['saml_authentication'] = isset($data['saml_authentication']) ? $data['saml_authentication'] : null;
        $this->container['sent_date_time'] = isset($data['sent_date_time']) ? $data['sent_date_time'] : null;
        $this->container['signature_info'] = isset($data['signature_info']) ? $data['signature_info'] : null;
        $this->container['signed_date_time'] = isset($data['signed_date_time']) ? $data['signed_date_time'] : null;
        $this->container['signer_email'] = isset($data['signer_email']) ? $data['signer_email'] : null;
        $this->container['signer_name'] = isset($data['signer_name']) ? $data['signer_name'] : null;
        $this->container['sign_in_each_location'] = isset($data['sign_in_each_location']) ? $data['sign_in_each_location'] : null;
        $this->container['signing_group_id'] = isset($data['signing_group_id']) ? $data['signing_group_id'] : null;
        $this->container['signing_group_name'] = isset($data['signing_group_name']) ? $data['signing_group_name'] : null;
        $this->container['signing_group_users'] = isset($data['signing_group_users']) ? $data['signing_group_users'] : null;
        $this->container['sms_authentication'] = isset($data['sms_authentication']) ? $data['sms_authentication'] : null;
        $this->container['social_authentications'] = isset($data['social_authentications']) ? $data['social_authentications'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['tabs'] = isset($data['tabs']) ? $data['tabs'] : null;
        $this->container['template_locked'] = isset($data['template_locked']) ? $data['template_locked'] : null;
        $this->container['template_required'] = isset($data['template_required']) ? $data['template_required'] : null;
        $this->container['total_tab_count'] = isset($data['total_tab_count']) ? $data['total_tab_count'] : null;
        $this->container['user_id'] = isset($data['user_id']) ? $data['user_id'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets access_code
     * @return string
     */
    public function getAccessCode()
    {
        return $this->container['access_code'];
    }

    /**
     * Sets access_code
     * @param string $access_code If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account’s access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.
     * @return $this
     */
    public function setAccessCode($access_code)
    {
        $this->container['access_code'] = $access_code;

        return $this;
    }

    /**
     * Gets add_access_code_to_email
     * @return string
     */
    public function getAddAccessCodeToEmail()
    {
        return $this->container['add_access_code_to_email'];
    }

    /**
     * Sets add_access_code_to_email
     * @param string $add_access_code_to_email This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.
     * @return $this
     */
    public function setAddAccessCodeToEmail($add_access_code_to_email)
    {
        $this->container['add_access_code_to_email'] = $add_access_code_to_email;

        return $this;
    }

    /**
     * Gets auto_navigation
     * @return string
     */
    public function getAutoNavigation()
    {
        return $this->container['auto_navigation'];
    }

    /**
     * Sets auto_navigation
     * @param string $auto_navigation 
     * @return $this
     */
    public function setAutoNavigation($auto_navigation)
    {
        $this->container['auto_navigation'] = $auto_navigation;

        return $this;
    }

    /**
     * Gets can_sign_offline
     * @return string
     */
    public function getCanSignOffline()
    {
        return $this->container['can_sign_offline'];
    }

    /**
     * Sets can_sign_offline
     * @param string $can_sign_offline When set to **true**, specifies that the signer can perform the signing ceremony offline.
     * @return $this
     */
    public function setCanSignOffline($can_sign_offline)
    {
        $this->container['can_sign_offline'] = $can_sign_offline;

        return $this;
    }

    /**
     * Gets client_user_id
     * @return string
     */
    public function getClientUserId()
    {
        return $this->container['client_user_id'];
    }

    /**
     * Sets client_user_id
     * @param string $client_user_id Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters.
     * @return $this
     */
    public function setClientUserId($client_user_id)
    {
        $this->container['client_user_id'] = $client_user_id;

        return $this;
    }

    /**
     * Gets custom_fields
     * @return string[]
     */
    public function getCustomFields()
    {
        return $this->container['custom_fields'];
    }

    /**
     * Sets custom_fields
     * @param string[] $custom_fields An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.
     * @return $this
     */
    public function setCustomFields($custom_fields)
    {
        $this->container['custom_fields'] = $custom_fields;

        return $this;
    }

    /**
     * Gets declined_date_time
     * @return string
     */
    public function getDeclinedDateTime()
    {
        return $this->container['declined_date_time'];
    }

    /**
     * Sets declined_date_time
     * @param string $declined_date_time The date and time the recipient declined the document.
     * @return $this
     */
    public function setDeclinedDateTime($declined_date_time)
    {
        $this->container['declined_date_time'] = $declined_date_time;

        return $this;
    }

    /**
     * Gets declined_reason
     * @return string
     */
    public function getDeclinedReason()
    {
        return $this->container['declined_reason'];
    }

    /**
     * Sets declined_reason
     * @param string $declined_reason The reason the recipient declined the document.
     * @return $this
     */
    public function setDeclinedReason($declined_reason)
    {
        $this->container['declined_reason'] = $declined_reason;

        return $this;
    }

    /**
     * Gets default_recipient
     * @return string
     */
    public function getDefaultRecipient()
    {
        return $this->container['default_recipient'];
    }

    /**
     * Sets default_recipient
     * @param string $default_recipient 
     * @return $this
     */
    public function setDefaultRecipient($default_recipient)
    {
        $this->container['default_recipient'] = $default_recipient;

        return $this;
    }

    /**
     * Gets delivered_date_time
     * @return string
     */
    public function getDeliveredDateTime()
    {
        return $this->container['delivered_date_time'];
    }

    /**
     * Sets delivered_date_time
     * @param string $delivered_date_time Reserved: For DocuSign use only.
     * @return $this
     */
    public function setDeliveredDateTime($delivered_date_time)
    {
        $this->container['delivered_date_time'] = $delivered_date_time;

        return $this;
    }

    /**
     * Gets delivery_method
     * @return string
     */
    public function getDeliveryMethod()
    {
        return $this->container['delivery_method'];
    }

    /**
     * Sets delivery_method
     * @param string $delivery_method Reserved: For DocuSign use only.
     * @return $this
     */
    public function setDeliveryMethod($delivery_method)
    {
        $this->container['delivery_method'] = $delivery_method;

        return $this;
    }

    /**
     * Gets document_visibility
     * @return \DocuSign\eSign\Model\DocumentVisibility[]
     */
    public function getDocumentVisibility()
    {
        return $this->container['document_visibility'];
    }

    /**
     * Sets document_visibility
     * @param \DocuSign\eSign\Model\DocumentVisibility[] $document_visibility 
     * @return $this
     */
    public function setDocumentVisibility($document_visibility)
    {
        $this->container['document_visibility'] = $document_visibility;

        return $this;
    }

    /**
     * Gets email_notification
     * @return \DocuSign\eSign\Model\RecipientEmailNotification
     */
    public function getEmailNotification()
    {
        return $this->container['email_notification'];
    }

    /**
     * Sets email_notification
     * @param \DocuSign\eSign\Model\RecipientEmailNotification $email_notification
     * @return $this
     */
    public function setEmailNotification($email_notification)
    {
        $this->container['email_notification'] = $email_notification;

        return $this;
    }

    /**
     * Gets embedded_recipient_start_url
     * @return string
     */
    public function getEmbeddedRecipientStartUrl()
    {
        return $this->container['embedded_recipient_start_url'];
    }

    /**
     * Sets embedded_recipient_start_url
     * @param string $embedded_recipient_start_url Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender’s system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient’s identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]`
     * @return $this
     */
    public function setEmbeddedRecipientStartUrl($embedded_recipient_start_url)
    {
        $this->container['embedded_recipient_start_url'] = $embedded_recipient_start_url;

        return $this;
    }

    /**
     * Gets error_details
     * @return \DocuSign\eSign\Model\ErrorDetails
     */
    public function getErrorDetails()
    {
        return $this->container['error_details'];
    }

    /**
     * Sets error_details
     * @param \DocuSign\eSign\Model\ErrorDetails $error_details
     * @return $this
     */
    public function setErrorDetails($error_details)
    {
        $this->container['error_details'] = $error_details;

        return $this;
    }

    /**
     * Gets fax_number
     * @return string
     */
    public function getFaxNumber()
    {
        return $this->container['fax_number'];
    }

    /**
     * Sets fax_number
     * @param string $fax_number Reserved:
     * @return $this
     */
    public function setFaxNumber($fax_number)
    {
        $this->container['fax_number'] = $fax_number;

        return $this;
    }

    /**
     * Gets host_email
     * @return string
     */
    public function getHostEmail()
    {
        return $this->container['host_email'];
    }

    /**
     * Sets host_email
     * @param string $host_email 
     * @return $this
     */
    public function setHostEmail($host_email)
    {
        $this->container['host_email'] = $host_email;

        return $this;
    }

    /**
     * Gets host_name
     * @return string
     */
    public function getHostName()
    {
        return $this->container['host_name'];
    }

    /**
     * Sets host_name
     * @param string $host_name Specifies the name of the signing host. It is a required element for In Person Signers recipient Type.  Maximum Length: 100 characters.
     * @return $this
     */
    public function setHostName($host_name)
    {
        $this->container['host_name'] = $host_name;

        return $this;
    }

    /**
     * Gets id_check_configuration_name
     * @return string
     */
    public function getIdCheckConfigurationName()
    {
        return $this->container['id_check_configuration_name'];
    }

    /**
     * Sets id_check_configuration_name
     * @param string $id_check_configuration_name Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.
     * @return $this
     */
    public function setIdCheckConfigurationName($id_check_configuration_name)
    {
        $this->container['id_check_configuration_name'] = $id_check_configuration_name;

        return $this;
    }

    /**
     * Gets id_check_information_input
     * @return \DocuSign\eSign\Model\IdCheckInformationInput
     */
    public function getIdCheckInformationInput()
    {
        return $this->container['id_check_information_input'];
    }

    /**
     * Sets id_check_information_input
     * @param \DocuSign\eSign\Model\IdCheckInformationInput $id_check_information_input
     * @return $this
     */
    public function setIdCheckInformationInput($id_check_information_input)
    {
        $this->container['id_check_information_input'] = $id_check_information_input;

        return $this;
    }

    /**
     * Gets inherit_email_notification_configuration
     * @return string
     */
    public function getInheritEmailNotificationConfiguration()
    {
        return $this->container['inherit_email_notification_configuration'];
    }

    /**
     * Sets inherit_email_notification_configuration
     * @param string $inherit_email_notification_configuration When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account.
     * @return $this
     */
    public function setInheritEmailNotificationConfiguration($inherit_email_notification_configuration)
    {
        $this->container['inherit_email_notification_configuration'] = $inherit_email_notification_configuration;

        return $this;
    }

    /**
     * Gets in_person_signing_type
     * @return string
     */
    public function getInPersonSigningType()
    {
        return $this->container['in_person_signing_type'];
    }

    /**
     * Sets in_person_signing_type
     * @param string $in_person_signing_type 
     * @return $this
     */
    public function setInPersonSigningType($in_person_signing_type)
    {
        $this->container['in_person_signing_type'] = $in_person_signing_type;

        return $this;
    }

    /**
     * Gets notary_host
     * @return \DocuSign\eSign\Model\NotaryHost
     */
    public function getNotaryHost()
    {
        return $this->container['notary_host'];
    }

    /**
     * Sets notary_host
     * @param \DocuSign\eSign\Model\NotaryHost $notary_host
     * @return $this
     */
    public function setNotaryHost($notary_host)
    {
        $this->container['notary_host'] = $notary_host;

        return $this;
    }

    /**
     * Gets note
     * @return string
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     * @param string $note Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.
     * @return $this
     */
    public function setNote($note)
    {
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets offline_attributes
     * @return \DocuSign\eSign\Model\OfflineAttributes
     */
    public function getOfflineAttributes()
    {
        return $this->container['offline_attributes'];
    }

    /**
     * Sets offline_attributes
     * @param \DocuSign\eSign\Model\OfflineAttributes $offline_attributes
     * @return $this
     */
    public function setOfflineAttributes($offline_attributes)
    {
        $this->container['offline_attributes'] = $offline_attributes;

        return $this;
    }

    /**
     * Gets phone_authentication
     * @return \DocuSign\eSign\Model\RecipientPhoneAuthentication
     */
    public function getPhoneAuthentication()
    {
        return $this->container['phone_authentication'];
    }

    /**
     * Sets phone_authentication
     * @param \DocuSign\eSign\Model\RecipientPhoneAuthentication $phone_authentication
     * @return $this
     */
    public function setPhoneAuthentication($phone_authentication)
    {
        $this->container['phone_authentication'] = $phone_authentication;

        return $this;
    }

    /**
     * Gets recipient_attachments
     * @return \DocuSign\eSign\Model\RecipientAttachment[]
     */
    public function getRecipientAttachments()
    {
        return $this->container['recipient_attachments'];
    }

    /**
     * Sets recipient_attachments
     * @param \DocuSign\eSign\Model\RecipientAttachment[] $recipient_attachments Reserved:
     * @return $this
     */
    public function setRecipientAttachments($recipient_attachments)
    {
        $this->container['recipient_attachments'] = $recipient_attachments;

        return $this;
    }

    /**
     * Gets recipient_authentication_status
     * @return \DocuSign\eSign\Model\AuthenticationStatus
     */
    public function getRecipientAuthenticationStatus()
    {
        return $this->container['recipient_authentication_status'];
    }

    /**
     * Sets recipient_authentication_status
     * @param \DocuSign\eSign\Model\AuthenticationStatus $recipient_authentication_status
     * @return $this
     */
    public function setRecipientAuthenticationStatus($recipient_authentication_status)
    {
        $this->container['recipient_authentication_status'] = $recipient_authentication_status;

        return $this;
    }

    /**
     * Gets recipient_id
     * @return string
     */
    public function getRecipientId()
    {
        return $this->container['recipient_id'];
    }

    /**
     * Sets recipient_id
     * @param string $recipient_id Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.
     * @return $this
     */
    public function setRecipientId($recipient_id)
    {
        $this->container['recipient_id'] = $recipient_id;

        return $this;
    }

    /**
     * Gets recipient_id_guid
     * @return string
     */
    public function getRecipientIdGuid()
    {
        return $this->container['recipient_id_guid'];
    }

    /**
     * Sets recipient_id_guid
     * @param string $recipient_id_guid 
     * @return $this
     */
    public function setRecipientIdGuid($recipient_id_guid)
    {
        $this->container['recipient_id_guid'] = $recipient_id_guid;

        return $this;
    }

    /**
     * Gets recipient_signature_providers
     * @return \DocuSign\eSign\Model\RecipientSignatureProvider[]
     */
    public function getRecipientSignatureProviders()
    {
        return $this->container['recipient_signature_providers'];
    }

    /**
     * Sets recipient_signature_providers
     * @param \DocuSign\eSign\Model\RecipientSignatureProvider[] $recipient_signature_providers 
     * @return $this
     */
    public function setRecipientSignatureProviders($recipient_signature_providers)
    {
        $this->container['recipient_signature_providers'] = $recipient_signature_providers;

        return $this;
    }

    /**
     * Gets recipient_supplies_tabs
     * @return string
     */
    public function getRecipientSuppliesTabs()
    {
        return $this->container['recipient_supplies_tabs'];
    }

    /**
     * Sets recipient_supplies_tabs
     * @param string $recipient_supplies_tabs 
     * @return $this
     */
    public function setRecipientSuppliesTabs($recipient_supplies_tabs)
    {
        $this->container['recipient_supplies_tabs'] = $recipient_supplies_tabs;

        return $this;
    }

    /**
     * Gets require_id_lookup
     * @return string
     */
    public function getRequireIdLookup()
    {
        return $this->container['require_id_lookup'];
    }

    /**
     * Sets require_id_lookup
     * @param string $require_id_lookup When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity.
     * @return $this
     */
    public function setRequireIdLookup($require_id_lookup)
    {
        $this->container['require_id_lookup'] = $require_id_lookup;

        return $this;
    }

    /**
     * Gets require_signer_certificate
     * @return string
     */
    public function getRequireSignerCertificate()
    {
        return $this->container['require_signer_certificate'];
    }

    /**
     * Sets require_signer_certificate
     * @param string $require_signer_certificate 
     * @return $this
     */
    public function setRequireSignerCertificate($require_signer_certificate)
    {
        $this->container['require_signer_certificate'] = $require_signer_certificate;

        return $this;
    }

    /**
     * Gets require_sign_on_paper
     * @return string
     */
    public function getRequireSignOnPaper()
    {
        return $this->container['require_sign_on_paper'];
    }

    /**
     * Sets require_sign_on_paper
     * @param string $require_sign_on_paper 
     * @return $this
     */
    public function setRequireSignOnPaper($require_sign_on_paper)
    {
        $this->container['require_sign_on_paper'] = $require_sign_on_paper;

        return $this;
    }

    /**
     * Gets role_name
     * @return string
     */
    public function getRoleName()
    {
        return $this->container['role_name'];
    }

    /**
     * Sets role_name
     * @param string $role_name Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.
     * @return $this
     */
    public function setRoleName($role_name)
    {
        $this->container['role_name'] = $role_name;

        return $this;
    }

    /**
     * Gets routing_order
     * @return string
     */
    public function getRoutingOrder()
    {
        return $this->container['routing_order'];
    }

    /**
     * Sets routing_order
     * @param string $routing_order Specifies the routing order of the recipient in the envelope.
     * @return $this
     */
    public function setRoutingOrder($routing_order)
    {
        $this->container['routing_order'] = $routing_order;

        return $this;
    }

    /**
     * Gets saml_authentication
     * @return \DocuSign\eSign\Model\RecipientSAMLAuthentication
     */
    public function getSamlAuthentication()
    {
        return $this->container['saml_authentication'];
    }

    /**
     * Sets saml_authentication
     * @param \DocuSign\eSign\Model\RecipientSAMLAuthentication $saml_authentication
     * @return $this
     */
    public function setSamlAuthentication($saml_authentication)
    {
        $this->container['saml_authentication'] = $saml_authentication;

        return $this;
    }

    /**
     * Gets sent_date_time
     * @return string
     */
    public function getSentDateTime()
    {
        return $this->container['sent_date_time'];
    }

    /**
     * Sets sent_date_time
     * @param string $sent_date_time The date and time the envelope was sent.
     * @return $this
     */
    public function setSentDateTime($sent_date_time)
    {
        $this->container['sent_date_time'] = $sent_date_time;

        return $this;
    }

    /**
     * Gets signature_info
     * @return \DocuSign\eSign\Model\RecipientSignatureInformation
     */
    public function getSignatureInfo()
    {
        return $this->container['signature_info'];
    }

    /**
     * Sets signature_info
     * @param \DocuSign\eSign\Model\RecipientSignatureInformation $signature_info
     * @return $this
     */
    public function setSignatureInfo($signature_info)
    {
        $this->container['signature_info'] = $signature_info;

        return $this;
    }

    /**
     * Gets signed_date_time
     * @return string
     */
    public function getSignedDateTime()
    {
        return $this->container['signed_date_time'];
    }

    /**
     * Sets signed_date_time
     * @param string $signed_date_time Reserved: For DocuSign use only.
     * @return $this
     */
    public function setSignedDateTime($signed_date_time)
    {
        $this->container['signed_date_time'] = $signed_date_time;

        return $this;
    }

    /**
     * Gets signer_email
     * @return string
     */
    public function getSignerEmail()
    {
        return $this->container['signer_email'];
    }

    /**
     * Sets signer_email
     * @param string $signer_email The email address for an InPersonSigner recipient Type.   Maximum Length: 100 characters.
     * @return $this
     */
    public function setSignerEmail($signer_email)
    {
        $this->container['signer_email'] = $signer_email;

        return $this;
    }

    /**
     * Gets signer_name
     * @return string
     */
    public function getSignerName()
    {
        return $this->container['signer_name'];
    }

    /**
     * Sets signer_name
     * @param string $signer_name Required. The full legal name of a signer for the envelope.   Maximum Length: 100 characters.
     * @return $this
     */
    public function setSignerName($signer_name)
    {
        $this->container['signer_name'] = $signer_name;

        return $this;
    }

    /**
     * Gets sign_in_each_location
     * @return string
     */
    public function getSignInEachLocation()
    {
        return $this->container['sign_in_each_location'];
    }

    /**
     * Sets sign_in_each_location
     * @param string $sign_in_each_location When set to **true**, specifies that the signer must sign in all locations.
     * @return $this
     */
    public function setSignInEachLocation($sign_in_each_location)
    {
        $this->container['sign_in_each_location'] = $sign_in_each_location;

        return $this;
    }

    /**
     * Gets signing_group_id
     * @return string
     */
    public function getSigningGroupId()
    {
        return $this->container['signing_group_id'];
    }

    /**
     * Sets signing_group_id
     * @param string $signing_group_id When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).
     * @return $this
     */
    public function setSigningGroupId($signing_group_id)
    {
        $this->container['signing_group_id'] = $signing_group_id;

        return $this;
    }

    /**
     * Gets signing_group_name
     * @return string
     */
    public function getSigningGroupName()
    {
        return $this->container['signing_group_name'];
    }

    /**
     * Sets signing_group_name
     * @param string $signing_group_name The display name for the signing group.   Maximum Length: 100 characters.
     * @return $this
     */
    public function setSigningGroupName($signing_group_name)
    {
        $this->container['signing_group_name'] = $signing_group_name;

        return $this;
    }

    /**
     * Gets signing_group_users
     * @return \DocuSign\eSign\Model\UserInfo[]
     */
    public function getSigningGroupUsers()
    {
        return $this->container['signing_group_users'];
    }

    /**
     * Sets signing_group_users
     * @param \DocuSign\eSign\Model\UserInfo[] $signing_group_users A complex type that contains information about users in the signing group.
     * @return $this
     */
    public function setSigningGroupUsers($signing_group_users)
    {
        $this->container['signing_group_users'] = $signing_group_users;

        return $this;
    }

    /**
     * Gets sms_authentication
     * @return \DocuSign\eSign\Model\RecipientSMSAuthentication
     */
    public function getSmsAuthentication()
    {
        return $this->container['sms_authentication'];
    }

    /**
     * Sets sms_authentication
     * @param \DocuSign\eSign\Model\RecipientSMSAuthentication $sms_authentication
     * @return $this
     */
    public function setSmsAuthentication($sms_authentication)
    {
        $this->container['sms_authentication'] = $sms_authentication;

        return $this;
    }

    /**
     * Gets social_authentications
     * @return \DocuSign\eSign\Model\SocialAuthentication[]
     */
    public function getSocialAuthentications()
    {
        return $this->container['social_authentications'];
    }

    /**
     * Sets social_authentications
     * @param \DocuSign\eSign\Model\SocialAuthentication[] $social_authentications Lists the social ID type that can be used for recipient authentication.
     * @return $this
     */
    public function setSocialAuthentications($social_authentications)
    {
        $this->container['social_authentications'] = $social_authentications;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets tabs
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function getTabs()
    {
        return $this->container['tabs'];
    }

    /**
     * Sets tabs
     * @param \DocuSign\eSign\Model\Tabs $tabs
     * @return $this
     */
    public function setTabs($tabs)
    {
        $this->container['tabs'] = $tabs;

        return $this;
    }

    /**
     * Gets template_locked
     * @return string
     */
    public function getTemplateLocked()
    {
        return $this->container['template_locked'];
    }

    /**
     * Sets template_locked
     * @param string $template_locked When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients.
     * @return $this
     */
    public function setTemplateLocked($template_locked)
    {
        $this->container['template_locked'] = $template_locked;

        return $this;
    }

    /**
     * Gets template_required
     * @return string
     */
    public function getTemplateRequired()
    {
        return $this->container['template_required'];
    }

    /**
     * Sets template_required
     * @param string $template_required When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.
     * @return $this
     */
    public function setTemplateRequired($template_required)
    {
        $this->container['template_required'] = $template_required;

        return $this;
    }

    /**
     * Gets total_tab_count
     * @return string
     */
    public function getTotalTabCount()
    {
        return $this->container['total_tab_count'];
    }

    /**
     * Sets total_tab_count
     * @param string $total_tab_count 
     * @return $this
     */
    public function setTotalTabCount($total_tab_count)
    {
        $this->container['total_tab_count'] = $total_tab_count;

        return $this;
    }

    /**
     * Gets user_id
     * @return string
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     * @param string $user_id 
     * @return $this
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this));
    }
}


