<?php
/**
 * MergeField
 *
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;

/**
 * MergeField Class Doc Comment
 *
 * @category    Class
 * @description Contains information for transfering values between Salesforce data fields and DocuSign Tabs.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class MergeField implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'mergeField';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'allow_sender_to_edit' => 'string',
        'configuration_type' => 'string',
        'path' => 'string',
        'row' => 'string',
        'write_back' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'allow_sender_to_edit' => 'allowSenderToEdit',
        'configuration_type' => 'configurationType',
        'path' => 'path',
        'row' => 'row',
        'write_back' => 'writeBack'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'allow_sender_to_edit' => 'setAllowSenderToEdit',
        'configuration_type' => 'setConfigurationType',
        'path' => 'setPath',
        'row' => 'setRow',
        'write_back' => 'setWriteBack'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'allow_sender_to_edit' => 'getAllowSenderToEdit',
        'configuration_type' => 'getConfigurationType',
        'path' => 'getPath',
        'row' => 'getRow',
        'write_back' => 'getWriteBack'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['allow_sender_to_edit'] = isset($data['allow_sender_to_edit']) ? $data['allow_sender_to_edit'] : null;
        $this->container['configuration_type'] = isset($data['configuration_type']) ? $data['configuration_type'] : null;
        $this->container['path'] = isset($data['path']) ? $data['path'] : null;
        $this->container['row'] = isset($data['row']) ? $data['row'] : null;
        $this->container['write_back'] = isset($data['write_back']) ? $data['write_back'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets allow_sender_to_edit
     * @return string
     */
    public function getAllowSenderToEdit()
    {
        return $this->container['allow_sender_to_edit'];
    }

    /**
     * Sets allow_sender_to_edit
     * @param string $allow_sender_to_edit When set to **true**, the sender can modify the value of the custom tab during the sending process.
     * @return $this
     */
    public function setAllowSenderToEdit($allow_sender_to_edit)
    {
        $this->container['allow_sender_to_edit'] = $allow_sender_to_edit;

        return $this;
    }

    /**
     * Gets configuration_type
     * @return string
     */
    public function getConfigurationType()
    {
        return $this->container['configuration_type'];
    }

    /**
     * Sets configuration_type
     * @param string $configuration_type If merge field's are being used, specifies the type of the merge field. The only  supported value is **salesforce**.
     * @return $this
     */
    public function setConfigurationType($configuration_type)
    {
        $this->container['configuration_type'] = $configuration_type;

        return $this;
    }

    /**
     * Gets path
     * @return string
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     * @param string $path Sets the object associated with the custom tab. Currently this is the Salesforce Object.
     * @return $this
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets row
     * @return string
     */
    public function getRow()
    {
        return $this->container['row'];
    }

    /**
     * Sets row
     * @param string $row Specifies the row number in a Salesforce table that the merge field value corresponds to.
     * @return $this
     */
    public function setRow($row)
    {
        $this->container['row'] = $row;

        return $this;
    }

    /**
     * Gets write_back
     * @return string
     */
    public function getWriteBack()
    {
        return $this->container['write_back'];
    }

    /**
     * Sets write_back
     * @param string $write_back When wet to true, the information entered in the tab automatically updates the related Salesforce data when an envelope is completed.
     * @return $this
     */
    public function setWriteBack($write_back)
    {
        $this->container['write_back'] = $write_back;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this));
    }
}


